/*
 * $Id$
 */
package csbase.client.applications;

import javax.swing.Action;
import javax.swing.KeyStroke;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.ClientKeyStrokeUtil;

/**
 * Classe abstrata para ser usada como primitiva para as aes que sejam
 * garantidamente padronizadas para as aplicaes CSBASE.
 * 
 * @author Tecgraf/PUC-Rio
 * @param <A> classe da aplicao.
 */
public abstract class ApplicationStandardAction<A extends Application> extends
  ApplicationAction<A> {

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  protected ApplicationStandardAction(A application) {
    super(application);
    final String className = getClass().getSimpleName();
    putValue(Action.NAME, LNG.get(className + ".name"));
    final String accTag = className + ".accelerator";
    if (LNG.hasKey(accTag)) {
      final String accTxt = LNG.get(accTag);
      final KeyStroke keyStroke = ClientKeyStrokeUtil.getAltKeyStroke(accTxt);
      putValue(Action.ACCELERATOR_KEY, keyStroke);
    }
  }
}
