package csbase.client.applications.algorithmsmanager.actions;

import javax.swing.ImageIcon;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmManagementPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmSelectionPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonManagementPanel;

/**
 * Representa a ao para gerenciamento de algoritmos.
 * 
 */
public class AlgorithmManagementAction extends CommonManagementAction {
  /**
   * Constri a ao de gerncia de algoritmos.
   * 
   * @param application referncia para a aplicao
   * @param icon imagem da ao
   */
  public AlgorithmManagementAction(AlgorithmsManager application, ImageIcon icon) {
    super(application, icon);
  }

  @Override
  protected AlgorithmManagementPanel getManagePanel() {
    return (AlgorithmManagementPanel) super.getManagePanel();
  }

  @Override
  public AlgorithmSelectionPanel getSelectionPanel() {
    return (AlgorithmSelectionPanel) super.getSelectionPanel();
  }

  @Override
  protected void selectInitialData() {
    getSelectionPanel().selectInitialData();
  }

  @Override
  protected CommonManagementPanel createManagementPanel(
    CommonManagementAction commonManagementAction) {
    return new AlgorithmManagementPanel(this);
  }
}
