package csbase.client.applications.algorithmsmanager.models;

import javax.swing.Icon;

import csbase.client.applications.ApplicationImages;
import csbase.logic.algorithms.AlgorithmInfo;

/**
 * Representa um item da lista de algoritmos. Cada n deve permitir exibir os
 * filhos associados a ele.
 * 
 * 
 */
public final class AlgorithmListItem implements DataInterface,
  Comparable<AlgorithmListItem> {
  /** O item (algoritmo) da lista */
  private AlgorithmInfo item;

  /**
   * Cria o item da lista.
   * 
   * @param item n da rvore (No aceita {@code null})
   */
  public AlgorithmListItem(AlgorithmInfo item) {
    this.item = item;
  }

  /**
   * (non-Javadoc)
   * 
   * @see java.lang.Comparable#compareTo(java.lang.Object)
   */
  public int compareTo(AlgorithmListItem item) {
    return getItem().compareTo(item.getItem());
  }

  /**
   * Obtm o item da lista de algoritmos.
   * 
   * @return o item
   */
  public AlgorithmInfo getItem() {
    return item;
  }

  @Override
  public String getId() {
    return getItem().getId();
  }

  @Override
  public String getName() {
    return getItem().getName();
  }

  @Override
  public String getFullName() {
    return getName();
  }

  /**
   * (non-Javadoc)
   * 
   * @see tecgraf.javautils.gui.tree.DefaultNode#getIcon()
   */
  @Override
  public Icon getIcon() {
    return ApplicationImages.ICON_ALGORITHM_16;
  }

  @Override
  public String toString() {
    return getName();
  }

  /**
   * Atribui novas informaes do algoritmo ao item correspondente.
   * 
   * @param algoInfo novo algoritmo
   */
  public void setItem(AlgorithmInfo algoInfo) {
    this.item = algoInfo;
  }

}
