package csbase.client.applications.algorithmsmanager.report.core;

import java.awt.Window;
import java.util.List;

import csbase.client.desktop.RemoteTask;

/**
 * Classe abstrata com implementao padro da iterao sobre os dados
 * utilizando task remota
 * 
 *
 * @author Tecgraf/PUC-Rio
 * @param <T> Tipo do dado sendo testado
 */
public abstract class AbstractRemoteTest<T> extends AbstractTest<T> {

  /**
   * Consturtor
   * 
   * @param taskParentWindow Janela me da janela da task.
   * @param taskTitle Ttulo da task.
   * @param taskMessage Mensagem da task.
   */
  public AbstractRemoteTest(Window taskParentWindow, String taskTitle,
    String taskMessage) {
    super(taskParentWindow, taskTitle, taskMessage);
  }

  /** {@inheritDoc} */
  @Override
  public ITestResult<T> run(final Iterable<T> subjects) {

    RemoteTask<ITestResult<T>> task = new RemoteTask<ITestResult<T>>() {
      @Override
      protected void performTask() throws Exception {
        TestResult<T> result = new TestResult<>();
        for (T subject : subjects) {
          List<IResultMessage<T>> messages = doTest(subject);
          result.addMessages(messages);
        }
        setResult(result);
      }
    };

    task.execute(getTaskParentWindow(), getTaskTitle(), getTaskMessage());

    return task.getResult();
  }
}
