package csbase.client.applications.algorithmsmanager.report.core;

import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import tecgraf.javautils.gui.Task;

/**
 * Executor de testes.
 *
 * @author Tecgraf/PUC-Rio
 */
public class TestRunner {

  /** Fbrica de objetos. */
  private final ISubjectFactory subjectFactory;

  /** Janela que disparou os testes */
  private final Window parentWindow;

  /** Ttulo da task */
  private String taskTitle;

  /** Mensagem da task */
  private String taskMessage;

  /**
   * Construtor.
   *
   * @param subjectFactory fbrica de objetos.
   * @param parentWindow Janela que disparou os testes
   * @param taskTitle Ttulo da task
   * @param taskMessage Mensagem da task
   */
  public TestRunner(ISubjectFactory subjectFactory, Window parentWindow,
    String taskTitle, String taskMessage) {
    this.taskTitle = taskTitle;
    this.taskMessage = taskMessage;
    this.parentWindow = parentWindow;
    this.subjectFactory = subjectFactory;
  }

  /**
   * Ao de rodar os testes
   * 
   * @param runQueue Os testes com suas respectivas fontes de dados
   * 
   * @return Lista de resultados
   */
  public Map<ITest<?>, ITestResult<?>> run(final List<ITest<?>> runQueue) {

    Task<Map<ITest<?>, ITestResult<?>>> task =
      new Task<Map<ITest<?>, ITestResult<?>>>() {

      /** {@inheritDoc} */
      @Override
      protected void performTask() throws Exception {
        Map<ITest<?>, ITestResult<?>> results = new HashMap<>();

        int i = 0;
        int n = runQueue.size();
        for (ITest<?> test : runQueue) {
          setProgressStatus(i * 100 / n);
          ITestResult<?> result = run(test);
          if (result != null) {
            results.put(test, result);
          }
          i++;
          if (i == n) {
            setProgressStatus(100);
          }
        }
        setResult(results);
      }

      /**
       * Ao de rodar um teste
       * 
       * @param test O teste a ser executado.
       * @return Lista de resultados
       */
      public <T> ITestResult<T> run(ITest<T> test) {
        Iterable<T> subject = subjectFactory.createSubject(test);
        if (subject == null) {
          return null;
        }
        return test.run(subject);

      }
    };

    task.execute(parentWindow, taskTitle, taskMessage, true, false);
    return task.getResult();

  }
}
