package csbase.client.applications.algorithmsmanager.versiontree;

import java.awt.datatransfer.DataFlavor;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import csbase.client.applications.algorithmsmanager.versiontree.actions.ExportReleaseNotesFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.RemoveReleaseNotesFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ReleaseNotesPathFactory;

/**
 * N que representa um release notes da verso.
 */
public final class ReleaseNotesFileNode extends AbstractFileInfoNode {

  /**
   * Descreve o formato de objeto que pode ser transferido pelas operaces de
   * transferncia (drag and drop ou clipboard) na rvore.
   */
  public static final DataFlavor DATA_FLAVOR = new DataFlavor(
    ReleaseNotesFileNode.class, ReleaseNotesFileNode.class.getSimpleName());

  /**
   * Construtor.
   * 
   * @param tree rvore que detm este n.
   * @param version Verso que detm o arquivo representado por este n.
   * @param file Arquivo representado por este n.
   */
  protected ReleaseNotesFileNode(final VersionTree tree,
    final AlgorithmVersionInfo version, final FileInfo file) {
    super(tree, version, file, file1 -> new ReleaseNotesFileNode(tree, version,
      file1), false);
  }

  /**
   * Cria um menu pop-up para este n.
   * 
   * @return um menu pop-up para este n.
   */
  @Override
  public JPopupMenu createPopupMenu() {
    JPopupMenu popupMenu = new JPopupMenu();
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
      new RemoveReleaseNotesFile(getTree(), getVersion(),
        getSelectedFiles()))));
    if (!getFile().isDirectory()) {
      popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
        new ExportReleaseNotesFile(getTree(), getVersion(), getFile()))));
    }

    return popupMenu;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataFlavor getDataFlavor() {
    return DATA_FLAVOR;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected final IPathFactory createSourcePathFactory(DataTransferObject dto) {
    AlgorithmVersionInfo sourceVersion = dto.getVersion();
    return new ReleaseNotesPathFactory(sourceVersion);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected final IPathFactory createTargetPathFactory() {
    return new ReleaseNotesPathFactory(getVersion());
  }

}
