/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.awt.event.ActionEvent;

import javax.swing.TransferHandler;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.VersionTreeClipboard;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.VersionTreeTransferHandler;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Ao que exporta, atravs do {@link VersionTreeTransferHandler
 *         TransferHandler} da rvore, objetos selecionados para o
 *         {@link VersionTreeClipboard clipboard}.
 */
public class CopyFile extends AbstractVersionTreeNodeAction {

  /** Nome padro da ao. */
  private static final String DEFAULT_NAME = "copy";

  /**
   * Contri uma instncia de {@link CopyFile} com o nome {@link #DEFAULT_NAME}
   * .
   * 
   * @param tree rvore que detm o n fonte da ao.
   */
  public CopyFile(VersionTree tree) {
    this(tree, DEFAULT_NAME);
  }

  /**
   * Conbstrutor.
   * 
   * @param tree rvore que detm o n fonte da ao.
   * @param name Nome da ao.
   */
  public CopyFile(VersionTree tree, String name) {
    super(tree, name);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    getTree().getTransferHandler().exportToClipboard(getTree(), null,
      TransferHandler.COPY);
  }
}
