package csbase.client.applications.commandsmonitor.actions;

import java.awt.event.ActionEvent;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;

/**
 * Recarrega lista de comandos do servidor.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class RefreshCommandsAction extends
  AbstractSimpleApplicationAction<Application> {

  /**
   * Construtor.
   * 
   * @param application Aplicao que detm esta ao.
   */
  public RefreshCommandsAction(Application application) {
    super(application, ApplicationImages.ICON_REFRESH_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    final Application application = getApplication();
    RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      public void performTask() throws Exception {
        CommandsCache.getInstance().hardReload(
          application.getApplicationProject());
      }
    };
    String title =
      getString("RefreshCommandsAction.task.commands.refresh.title");
    String msg =
      getString("RefreshCommandsAction.task.commands.refresh.message");
    if (!task.execute(application.getApplicationFrame(), title, msg)) {
      if (task.getError() != null) {
        application.showExceptionStack(task.getError());
      }
    }
  }

}
