package csbase.client.applications.commandsmonitor.actions;

import java.awt.event.ActionEvent;

import javax.swing.JTree;
import javax.swing.tree.TreePath;

import tecgraf.javautils.core.io.FileUtils;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeModel;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandInfo;
import csbase.logic.CommonClientProject;

/**
 * Mostra o diretrio de persistncia do comando selecionado na rvore de
 * projetos.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class ShowCommandDirAction extends AbstractCommandsAction {

  /**
   * Construtor.
   * 
   * @param application Aplicao que detm esta ao.
   */
  public ShowCommandDirAction(CommandsMonitor application) {
    super(application, false, ApplicationImages.ICON_TREE_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean accept(CommandInfo command) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    showCommandDirInProjectTree();
  }

  /**
   * Revela o diretrio de persistncia do comando na rvore de projetos do
   * desktop.
   */
  private void showCommandDirInProjectTree() {
    final CommandsMonitor application = getApplication();
    final CommandInfo command = getSelectedCommand();
    if (command != null) {
      String cmdId = command.getId();

      RemoteTask<Boolean> showCommandDirTask = new RemoteTask<Boolean>() {

        /**
         * {@inheritDoc}
         */
        @Override
        protected void performTask() throws Exception {
          DesktopFrame desktopFrame = application.getDesktopFrame();
          ProjectTree projectTree = desktopFrame.getTree();
          CommonClientProject project = projectTree.getProject();
          JTree jTree = projectTree.getTree();

          String[] persistencyPath = command.getPersistencyPath();
          if (persistencyPath == null || persistencyPath.length == 0) {
            setResult(false);
            return;
          }

          // Expande o n do diretrio de persistncia do comando especificado
          ClientProjectFile persistencyDir = project.getFile(persistencyPath);

          ProjectTreeModel model = (ProjectTreeModel) jTree.getModel();
          TreePath cmdNode = model.getTreePath(persistencyDir);
          if (cmdNode == null) {
            setResult(false);
            return;
          }
          jTree.expandPath(cmdNode);
          jTree.setSelectionPath(cmdNode);
          jTree.scrollPathToVisible(cmdNode);
          setResult(true);
        }
      };

      String title =
        getString("ShowCommandDirAction.task.show.commands.dir.title");
      String message =
        getString("ShowCommandDirAction.task.show.commands.dir.message");
      if (!showCommandDirTask.execute(application.getApplicationFrame(), title,
        message)) {
        application.showException(
          getString("ShowCommandDirAction.task.show.commands.dir.error",
            FileUtils.fixDirectoryName(cmdId)), showCommandDirTask.getError());
      }
      else {
        Boolean result = showCommandDirTask.getResult();
        if (result == null || !result) {
          application
            .showError(getString("ShowCommandDirAction.task.show.commands.dir.error.not.found"));
        }
      }
    }

  }
}
