/*
 * $Id:$
 */

package csbase.client.applications.commandsmonitor.dal.xml.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLElement;
import tecgraf.javautils.xml.XMLElementInterface;
import csbase.client.applications.commandsmonitor.models.TablesTabDTO;

/**
 * Elemento de tab.
 * 
 * @author Tecgraf
 */
public class TabElement extends XMLElement {

  /**
   * Consulta o nome da tag
   * 
   * @return tag
   */
  public static final String getTagName() {
    return "tab";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {

    // Pega o id da tabela.
    String id = getAttributeStrValue("id");

    // Pega o id das tabelas.
    List<String> tablesId = new ArrayList<String>();
    ImprovedXMLListIterator iterator =
      new ImprovedXMLListIterator(childrenList);
    XMLElementInterface tableElement;
    while (null != (tableElement =
      iterator.next(TableReferenceElement.getTagName()))) {
      String aColumnId = (String) tableElement.getAppObject();
      tablesId.add(aColumnId);
    }

    setAppObject(new TablesTabDTO(id, tablesId));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer writer, String ident) throws IOException {
    throw new IllegalAccessError("Esse mtodo no deve ser utilizado.");
  }
}
