/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import java.awt.Component;
import java.rmi.RemoteException;
import java.util.Locale;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo a descrio do comando.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class DescriptionColumn extends AbstractCommandsTableColumn {

  /**
   * Construtor.
   * 
   * @param id Identificador da coluna.
   * @param appRegistry registro da aplicao que ser utilizado para se obter o
   *        nome da coluna de acordo com o {@link Locale}.
   */
  public DescriptionColumn(String id, ApplicationRegistry appRegistry) {
    super(String.class, id, appRegistry, true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    if (cmd.getStatus() == CommandStatus.SYSTEM_FAILURE) {
      return null;
    }
    else if (cmd.getDescription() == null) {
      return "";
    }
    else {
      return cmd.getDescription();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setValue(final CommandInfo cmd, Object value) {
    String previousDescription = cmd.getDescription();

    String description = value.toString();
    cmd.setDescription(0 == description.length() ? null : description);

    RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      protected void performTask() throws RemoteException {
        CommandsCache.getInstance().updateDescription(cmd);
      }
    };
    String taskTitle = getGenericString("task.command.update.title");
    String taskMessage = getGenericString("task.command.update.message");
    boolean success = task.execute(null, taskTitle, taskMessage);
    if (!success) {
      cmd.setDescription(previousDescription);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return new DefaultTableCellRenderer() {
      @Override
      public Component getTableCellRendererComponent(JTable table,
        Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp =
          super.getTableCellRendererComponent(table, value, isSelected,
            hasFocus, row, column);

        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer) comp;
        if (value == null) {
          renderer.setText(getDefaultErrorValue());
          renderer.setIcon(null);
        }
        else {
          renderer.setText(value.toString());
          /**
           * Se a clular for editvel, renderiza ela com um cone de um lpis
           * no lado esquerdo..
           */
          if (isColumnEditable()) {
            renderer.setIcon(ApplicationImages.ICON_EDITABLE_TABLE_CELL_14);
          }          
        }

        return this;
      }
    };
  }
}
