/*
 * $Id:$
 */
package csbase.client.applications.diskmonitor;

/**
 * Thread de atualizao da lista de requisies.
 * 
 * @author Tecgraf/PUC-Rio
 */
class DiskMonitorThread extends Thread {

  /**
   * Aplicao
   */
  final private DiskMonitor application;

  /**
   * Indicativo de execuo.
   */
  private boolean running = true;

  /**
   * Tempo em segundos do refresh
   */
  final static private int N = 10;

  /**
   * {@inheritDoc}
   */
  @Override
  public void run() {
    while (running) {
      try {
        application.refresh();
        Thread.sleep(1000 * N);
      }
      catch (InterruptedException e) {
      }
      catch (Exception e) {
        application.showExceptionStack(e);
      }
    }
  }

  /**
   * Finalizao da thread.
   */
  final void killThread() {
    running = false;
    interrupt();
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  DiskMonitorThread(final DiskMonitor application) {
    this.application = application;
  }
}
