/*
 * $Id$
 */
package csbase.client.applications.filetransferclient;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.ApplicationImages;
import csbase.client.util.AnimatedIcon;
import csbase.logic.ClientProjectFile;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import csbase.logic.filetransferservice.FileTransferRequestType;

/**
 * Classe auxiliar de interface grfica.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileTransferClientUI {

  /**
   * Identificador de aplicao.
   */
  final private static String ID = "filetransferclient";

  /**
   * Subdiretrio (em resources) para as imagens de tipos de arquivos.
   */
  final private static String FTDIR = "filetypes/";

  /**
   * Subdiretrio (em resources) para as imagens de status
   */
  final private static String STDIR = "status/";

  /**
   * cone para conexo rpida.
   */
  final public static ImageIcon FAST_CONNECT_ICON =
    buildImageIcon("fast.connect.16.gif");

  /**
   * cone para parte remota
   */
  final public static ImageIcon REMOTE_ICON = buildImageIcon("remote.16.gif");

  /**
   * cone de tipo: diretrio
   */
  final public static ImageIcon IMG_TYPE_DIRECTORY =
    ApplicationImages.ICON_SIMPLE_FOLDER_16;

  /**
   * cone de tipo: arquivo
   */
  final public static ImageIcon IMG_TYPE_FILE = buildImageIcon(FTDIR
    + "file.16.gif");

  /**
   * cone de tipo: link
   */
  final public static ImageIcon IMG_TYPE_LINK = ApplicationImages.ICON_LINK_16;

  /**
   * Cria uma imagem esttica a partir do caminho especificado.
   * 
   * @param path O caminho da imagem.
   * @return A imagem.
   */
  final private static ImageIcon buildImageIcon(final String path) {
    return FileTransferClient.getImageIcon(FileTransferClient.class, path);
  }

  /**
   * Cria uma imagem animada a partir do caminho especificado.
   * 
   * @param path O caminho da imagem.
   * @return A imagem.
   */
  final private static AnimatedIcon buildAnimatedIcon(final String path) {
    ImageIcon imageIcon = buildImageIcon(path);
    if (imageIcon != null) {
      return new AnimatedIcon(imageIcon);
    }
    return null;
  }

  /**
   * Teste se uma string  nula.
   * 
   * @param str a string a ser testada
   * @return um indicativo booleano
   */
  public static boolean isEmptyString(final String str) {
    if (str == null) {
      return true;
    }
    final String s = str.trim();
    if (s.equals("")) {
      return true;
    }
    return false;
  }

  /**
   * Converte um path em uma string.
   * 
   * @param prjFile diretrio
   * @return path em forma de texto
   */
  public static String pathToString(final ClientProjectFile prjFile) {
    final String[] path = prjFile.getPath();
    final int npath = path.length;
    String text = "";
    for (int i = 0; i < npath; i++) {
      text = text + "/" + path[i];
    }
    return text;
  }

  /**
   * Consulta a imagem de um estado de requisico.
   * 
   * @param status estado.
   * @return imagem
   */
  public static Icon getStatusIcon(FileTransferRequestStatus status) {
    final String path = STDIR + status.name() + ".16.gif";
    if (status == FileTransferRequestStatus.RUNNING) {
      return buildAnimatedIcon(path);
    }
    return buildImageIcon(path);
  }

  /**
   * Consulta a imagem de um tipo de requisico.
   * 
   * @param type tipo
   * @return imagem.
   */
  public static Icon getTypeIcon(FileTransferRequestType type) {
    final ImageIcon exp = ApplicationImages.ICON_EXPORT_16;
    final ImageIcon imp = ApplicationImages.ICON_IMPORT_16;
    return type == FileTransferRequestType.DOWNLOAD ? imp : exp;
  }

  /**
   * Consultado texto de uma classe.
   * 
   * @param clazz classe
   * @param tag tag
   * @return texto
   */
  public static String getString(final Class<?> clazz, final String tag) {
    final ApplicationManager mgr = ApplicationManager.getInstance();
    final ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
    return reg.getString(clazz.getSimpleName() + "." + tag);
  }

  /**
   * Consulta o texto de tooltip de um estado.
   * 
   * @param status estado
   * @return texto
   */
  public static String getStatusTooltip(FileTransferRequestStatus status) {
    final String tag = status.toString() + ".tooltip";
    return getString(FileTransferRequestStatus.class, tag);
  }

  /**
   * Consulta o texto de tooltip de um tipo.
   * 
   * @param type tipo.
   * @return texto
   */
  public static String getTypeTooltip(FileTransferRequestType type) {
    final String tag = type.toString() + ".tooltip";
    return getString(FileTransferRequestType.class, tag);
  }

  /**
   * Colocao de uma borda com linha e texto em um componente.
   * 
   * @param component o componente a ser colocado sob a borda.
   */
  public static void setEtchedBorder(final JComponent component) {
    final int BRD_GAP = 5;
    component.setBorder(BorderFactory.createCompoundBorder(BorderFactory
      .createEmptyBorder(BRD_GAP, BRD_GAP, BRD_GAP, BRD_GAP), BorderFactory
      .createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory
        .createEmptyBorder(BRD_GAP, BRD_GAP, BRD_GAP, BRD_GAP))));
  }
}
