/*
 * $Id$
 */
package csbase.client.applications.filetransferclient;

/**
 * Thread de atualizao da lista de requisies.
 * 
 * @author Tecgraf/PUC-Rio
 */
class FileTransferQueueThread extends Thread {

  /**
   * Aplicao
   */
  final private FileTransferClient application;

  /**
   * Indicativo de execuo.
   */
  private boolean running = true;

  /**
   * Tempo em segundos do refresh
   */
  final static private int N = 5;

  /**
   * {@inheritDoc}
   */
  @Override
  public void run() {
    while (running) {
      try {
        Thread.sleep(1000 * N);
        application.getQueuePanel().refresh();
      }
      catch (InterruptedException e) {
      }
      catch (Exception e) {
        application.showExceptionStack(e);
      }
    }
  }

  /**
   * Finalizao da thread.
   */
  final void killThread() {
    running = false;
    interrupt();
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  FileTransferQueueThread(final FileTransferClient application) {
    this.application = application;
  }
}
