/*
 * $Id$
 */

/*
 * $Id$
 */
package csbase.client.applications.filetransferclient.actions;

import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.remotepanel.FileTransferClientRemotePanel;
import csbase.logic.filetransferservice.FileTransferElement;

/**
 * Ao para trocar de diretrio remoto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ChangeRemoteDirectoryAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient application = getApplication();
    final FileTransferClientRemotePanel remotePanel =
      application.getRemotePanel();

    final List<FileTransferElement> selFiles =
      remotePanel.getSelectedElements();
    if (selFiles == null || selFiles.size() == 0) {
      return;
    }

    if (selFiles.size() != 1) {
      final String msg = getString("multiple.elements.error");
      application.showError(msg);
      return;
    }

    final FileTransferElement selFile = selFiles.get(0);
    if (selFile == null) {
      return;
    }

    final String remoteDir = remotePanel.getRemoteDirectory();
    final String newDir = remoteDir + "/" + selFile.getName();
    remotePanel.setRemoteDirectory(newDir);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  public ChangeRemoteDirectoryAction(final FileTransferClient application) {
    super(application);
  }
}
