/*
 * $Id$
 */

package csbase.client.applications.filetransferclient.actions;

import java.awt.Font;
import java.awt.GridBagLayout;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferPredefinedConnection;
import csbase.logic.filetransferservice.FileTransferProtocol;

/**
 * Ao de troca de diretrio local
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FastConnectAction extends FileTransferClientAction {

  /**
   * Conexo predefinida.
   */
  final private FileTransferPredefinedConnection predef;

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient application = getApplication();
    final ApplicationFrame frame = application.getApplicationFrame();
    final String passwordStr = getString("password.label");
    final String title = getString("password.title");
    final JPasswordField passwordText = new JPasswordField(10);
    final JLabel passwordLabel = new JLabel(passwordStr);
    final JComponent[][] cmps = new JComponent[][] { { passwordLabel, passwordText } };
    
    final JLabel destLabel = new JLabel();
    destLabel.setText(predef.toString());
    destLabel.setFont(new Font(Font.MONOSPACED,Font.PLAIN, 12));
    
    final JPanel panel = new JPanel();
    panel.setLayout(new GridBagLayout());
    panel.add(destLabel, new GBC(0,0).horizontal());
    panel.add(GUIUtils.createBasicGridPanel(cmps), new GBC(0,1).horizontal());

    final int option = JOptionPane.showOptionDialog(frame, panel, title,
      JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE, null, null, null);
    if (option == JOptionPane.CANCEL_OPTION || option == JOptionPane.CLOSED_OPTION) {
      return;
    }

    @SuppressWarnings("deprecation")
    final String password = passwordText.getText();
    final User loggedUser = User.getLoggedUser();
    final Object userId = loggedUser.getId();
    final DesktopFrame desktopFrame = DesktopFrame.getInstance();
    final CommonClientProject project = desktopFrame.getProject();
    final Object projectId = project.getId();

    final FileTransferProtocol protocol = predef.getProtocol();
    final String serverName = predef.getServerName();
    final String userName = predef.getUserName();
    final String homePath = predef.getHomePath();

    final FileTransferConnection connection =
      new FileTransferConnection(protocol, serverName, userName, password,
        userId, projectId, homePath);
    final FileTransferProxy proxy = application.getServiceProxy();
    if (!proxy.checkConnection(connection)) {
      final String fmt = getString("connection.failure.error");
      final String err = String.format(fmt, userName, serverName);
      application.showError(err);
      application.setConnection(null);
      return;
    }

    application.setConnection(connection);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return FileTransferClientUI.FAST_CONNECT_ICON;
  }

  /**
   * Construtor
   * 
   * @param application a aplicaco
   * @param predef conexo predefinida.
   */
  public FastConnectAction(final FileTransferClient application,
    FileTransferPredefinedConnection predef) {
    super(application);
    this.predef = predef;
    putValue(NAME, predef.getLabel());
    putValue(LONG_DESCRIPTION, predef.getUserName() + "@"
      + predef.getServerName());
  }

}
