/*
 * $Id$
 */

package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.localpanel.FileTransferClientLocalPanel;

/*
 * $Id$
 */

/**
 * @author Tecgraf/PUC-Rio
 */
public class HomeLocalAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient app = getApplication();
    final FileTransferClientLocalPanel localPanel = app.getLocalPanel();
    localPanel.setLocalDirectory(null);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  public HomeLocalAction(final FileTransferClient application) {
    super(application);
  }

}
