/*
 * $Id$
 */
package csbase.client.applications.filetransferclient.actions;

import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.queuepanel.FileTransferClientQueuePanel;

/**
 * @author Tecgraf/PUC-Rio
 * 
 */
public final class RequestRemoveAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    final FileTransferClient application = getApplication();
    final FileTransferClientQueuePanel queuePanel = application.getQueuePanel();
    final List<String> ids = queuePanel.getSelectedRequestsIds();
    final FileTransferProxy proxy = application.getServiceProxy();
    proxy.removeRequests(ids);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_DELETE_16;
  }

  /**
   * Construtor.
   * 
   * @param application aplicaco.
   */
  public RequestRemoveAction(final FileTransferClient application) {
    super(application);
  }
}
