package csbase.client.applications.flowapplication.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D.Double;

import tecgraf.vix.TypeVS;

/**
 * Representa uma decorao do tipo texto de um n do grafo.
 */
public class GraphNodeTextDecoration extends
  AbstractGraphNodeDecoration<GraphString> {

  /**
   * Fonte padro da decorao.
   */
  private static final Font DEFAULT_FONT = new Font(Font.SANS_SERIF, Font.BOLD,
    10);

  /**
   * Construtor.
   * 
   * @param vs o vs.
   * @param text o texto.
   * @param description a descrio.
   */
  public GraphNodeTextDecoration(TypeVS vs, String text, String description) {
    super(new GraphString(vs, text, DEFAULT_FONT), description);
    this.vo.setColor(Color.BLUE);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setRectangle(Double rect) {
    double desiredWidth = rect.getWidth();
    double actualWidth = getWidth();
    if (actualWidth > 0 && desiredWidth < actualWidth) {
      Font currentFont = this.vo.getFont();
      int oldSize = currentFont.getSize();
      int newFontSize = (int) Math.ceil(oldSize * (desiredWidth / actualWidth));
      this.vo.setFont(currentFont.deriveFont(newFontSize));
    }
    this.vo.setLocation(rect.getCenterX(), rect.getCenterY());
  }

  /**
   * Atribui um novo texto  decorao.
   * 
   * @param text o texto.
   */
  public void setText(String text) {
    this.vo.setText(text);
  }

}
