package csbase.client.applications.flowapplication.graph.actions;

import java.awt.Window;

import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.util.StandardErrorDialogs;

/**
 * Ao abstrata de menu popup para o elementos do fluxo de algoritmos.
 * 
 * @author lmoreira
 */
public abstract class GraphElementAction extends Action {
  /**
   * Elemento.
   */
  private final GraphElement element;

  /**
   * Cria a ao.
   * 
   * @param element O elemento do fluxo (No aceita {@code null}).
   * @param nameKey O nome da chave do mecanismo de internacionalizao com o
   *        nome da ao.
   * @param icon O cone da ao.
   * @param acceleratorKeyStroke A tecla que dispara a ao.
   */
  protected GraphElementAction(final GraphElement element,
    final String nameKey, final ImageIcon icon,
    final KeyStroke acceleratorKeyStroke) {
    super(nameKey, icon, acceleratorKeyStroke);
    this.element = element;
  }

  /**
   * Cria a ao.
   * 
   * @param element O elemento do fluxo (No aceita {@code null}).
   * @param nameKey O nome da chave do mecanismo de internacionalizao com o
   *        nome da ao.
   * @param icon O cone da ao.
   */
  protected GraphElementAction(final GraphElement element,
    final String nameKey, final ImageIcon icon) {
    super(nameKey, icon);
    this.element = element;
  }

  /**
   * Obtm o elemento.
   * 
   * @return O elemento.
   */
  protected GraphElement getElement() {
    return this.element;
  }

  /**
   * Obtm a janela pai do menu popup.
   * 
   * @return A janela.
   */
  protected final Window getParentWindow() {
    final Graph graph = element.getGraph();
    final Window window = graph.getParentWindow();
    return window;
  }

  /**
   * Exibe um dilogo com uma exceo.
   * 
   * @param exception A exceo (No aceita {@code null}).
   */
  protected final void showErrorDialog(final Exception exception) {
    final Window window = getParentWindow();
    StandardErrorDialogs.showErrorDialog(window, exception.getMessage(),
      exception);
  }

  /**
   * Exibe um dilogo com uma mensagem de erro.
   * 
   * @param message A mensagem de erro (No aceita {@code null}).
   */
  protected final void showErrorDialog(final String message) {
    final Window window = getParentWindow();
    StandardErrorDialogs.showErrorDialog(window, message);
  }

  /**
   * Exibe um dilogo com um aviso.
   * 
   * @param message O aviso (No aceita {@code null}).
   * @param title O ttulo do dilogo (No aceita {@code null}).
   */
  protected final void showWarning(final String message, final String title) {
    final Window window = getParentWindow();
    StandardDialogs.showWarningDialog(window, title, message);
  }
}
