package csbase.client.applications.flowapplication.messages;

import tecgraf.vix.Message;

/**
 * Mensagem de erro.
 */
public final class ErrorMessage extends Message {
  /** Os argumentos da chave. */
  private Object[] arguments;

  /** Exceo gerada. */
  private Exception exception;

  /**
   * Chave para localizar a mensagem de erro no mecanismo de
   * internacionalizao.
   */
  private String key;

  /**
   * Cria uma mensagem de erro baseada na exceo.
   * 
   * @param exception A exceo.
   */
  public ErrorMessage(final Exception exception) {
    super();
    this.exception = exception;
  }

  /**
   * Cria uma mensagem de erro baseada na chave.
   * 
   * @param key A chave.
   */
  public ErrorMessage(final String key) {
    super();
    this.key = key;
  }

  /**
   * Cria uma mensagem de erro baseada na chave.
   * 
   * @param key A chave.
   * @param arguments Os argumentos da chave.
   */
  public ErrorMessage(final String key, final Object... arguments) {
    super();
    this.key = key;
    this.arguments = arguments;
  }

  /**
   * Obtm os argumentos da chave.
   * 
   * @return Os arguments da chave.
   */
  public Object[] getArguments() {
    return this.arguments;
  }

  /**
   * Obtm a exceo.
   * 
   * @return A exceo ou <code>null</code> se ela no foi informada.
   */
  public Exception getException() {
    return this.exception;
  }

  /**
   * Obtm a chave.
   * 
   * @return A chave ou <code>null</code> se ela no foi informada.
   */
  public String getKey() {
    return this.key;
  }
}
