/*
 * $Id$
 */
package csbase.client.applications.imageviewer.actions.io;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.actions.ImageViewerAction;

/**
 * Ao de fecahr arquivo corrente.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ImageViewerCloseAction extends ImageViewerAction {

  /**
   * {@inheritDoc}
   */
  @Override
  protected ImageIcon getDefaultIcon() {
    return ApplicationImages.ICON_CLOSE_16;
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public ImageViewerCloseAction(ImageViewer application) {
    super(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) {
    final ImageViewer application = getApplication();
    application.closeFile();
  }

}
