package csbase.client.applications.pdfviewer.actions;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.ClientLocalFile;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.pdfviewer.PDFViewer;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.logic.ClientFile;

/**
 * Ao que abre um arquivo PDF de um disco local
 * 
 * @author Tecgraf
 */
public class OpenLocalPdfFileAction extends AbstractOpenPdfFileAction {

  /** Referncia para o ltimo diretrio navegado. */
  private ClientLocalFile lastDirectory;

  /**
   * Construtor padro.
   * 
   * @param application aplicao.
   */
  public OpenLocalPdfFileAction(PDFViewer application) {
    super(application, ApplicationImages.ICON_OPEN_LOCAL_16);

  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ClientFile chooseClientFileOrNull() {
    Application application = getApplication();

    ApplicationFrame window = application.getApplicationFrame();
    String title = application.getName();

    ClientLocalFile clientLocalFile =
      ClientLocalFileChooserUtil.browseSingleFileInOpenMode(window,
        getProjectFileExtensions(), title, true, lastDirectory);

    if (clientLocalFile == null) {
      return null;
    }

    lastDirectory = clientLocalFile.getParent();

    if (clientLocalFile.exists()) {
      return clientLocalFile;
    }
    else {
      StandardDialogs.showErrorDialog(window, getApplication().getString(
        "pdfviewer.open.error.title"),
        getString("OpenLocalPdfFileAction.file.not.found.error"));
      return null;
    }
  }
}