/*
 * $Id:$
 */

package csbase.client.applications.projectsmanager.actions;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;

/**
 * Ao responsvel por exibir ou esconder o painel de filtros.
 * 
 * @author Tecgraf/PUC-Rio
 * 
 */
public class DisplayFilterAction extends ProjectsManagerAction {

  /**
   * Boolean que indica se painel est sendo exibido ou no.
   */
  private boolean display;

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_FILTER_16;
  }

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public DisplayFilterAction(final ProjectsManager projectsManager) {
    super(projectsManager);
    display = false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    display = !display;
    final ProjectsManager projectsManager = getProjectsManager();
    projectsManager.displayFilters(display);
  }

}
