/**
 * $Id$
 */

package csbase.client.applications.projectsmanager.panels.filters;

import javax.swing.JLabel;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;

/**
 * Painel que contm os filtros por data de criao de projeto.
 * 
 * @author jnlopes
 */
public class ProjectCreationDateFilterPanel extends AbstractProjectDateFilter {

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public ProjectCreationDateFilterPanel(final ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean projectMatchesFilter(final long initialDate,
    final long finalDate, ProjectsManagerData prj) {
    final long creationDate = prj.getCreationDate();
    return creationDate >= initialDate && creationDate <= finalDate;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JLabel createMainLabel() {
    final String label =
      getString("ProjectCreationDateFilterPanel.creation.date.title");
    return new JLabel(label);
  }
}
