package csbase.client.applications.projectsmanager.panels.renderers;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;

/**
 * Renderer da coluna de filesystem do projeto.
 * 
 * @author jnlopes
 */
public class ServerLocationRenderer extends DefaultTableCellRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    final Component component =
      super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
        row, column);
    final JLabel label = (JLabel) component;

    label.setHorizontalAlignment(SwingConstants.LEFT);

    if (value == null) {
      label.setText(null);
    }
    else {

      final String location = (String) value;

      final ProjectSpaceAllocation psa =
        (ProjectSpaceAllocation) table.getValueAt(row, 1);

      if (psa == ProjectSpaceAllocation.WAITING_ALLOCATION
        || psa == ProjectSpaceAllocation.WAITING_DEALLOCATION) {
        label.setForeground(Color.gray);
      }
      else {
        label.setForeground(Color.black);
      }

      label.setText(location);
    }

    return label;
  }

}
