package csbase.client.applications.projectsynchronization;

import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.ServiceFailureException;
import csbase.logic.ProjectSynchronizationData;
import csbase.logic.ProjectSynchronizationListProjects;
import csbase.logic.UserProjectInfo;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectSynchronizationServiceInterface;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.WizardException;

public class StepSelectionProjects extends StepProjectSynchronization {
  private ContainerSelectionProjects containerSelectionProjects;
  protected ProjectSynchronizationData data;
  private boolean sameProjectFlag;
  private List listProjectsServerA;
  private List listProjectsServerB;
  private ApplicationRegistry registry;
  private String error;

  public StepSelectionProjects(ApplicationRegistry registry) {
    this.registry = registry;
    containerSelectionProjects = new ContainerSelectionProjects(registry);
  }

  private int getSelectIndexProjectA() {
    return containerSelectionProjects.getProjectsSelectionA().getCbProjetos()
      .getSelectedIndex();
  }

  private int getSelectIndexProjectB() {
    return containerSelectionProjects.getProjectsSelectionB().getCbProjetos()
      .getSelectedIndex();
  }

  private Object getSelectItemProjectA() {
    UserProjectInfo project = (UserProjectInfo) containerSelectionProjects
      .getProjectsSelectionA().getCbProjetos().getSelectedItem();
    return (project != null) ? project.getProjectId() : null;
  }

  private Object getSelectItemProjectB() {
    UserProjectInfo project = (UserProjectInfo) containerSelectionProjects
      .getProjectsSelectionB().getCbProjetos().getSelectedItem();
    return (project != null) ? project.getProjectId() : null;
  }

  private String getSelectItemProjectNameA() {
    UserProjectInfo project = (UserProjectInfo) containerSelectionProjects
      .getProjectsSelectionA().getCbProjetos().getSelectedItem();
    return (project != null) ? project.getProjectName() : null;
  }

  private String getSelectItemProjectNameB() {
    UserProjectInfo project = (UserProjectInfo) containerSelectionProjects
      .getProjectsSelectionB().getCbProjetos().getSelectedItem();
    return (project != null) ? project.getProjectName() : null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void enter(History history) throws WizardException {
    error = null;
    data = (ProjectSynchronizationData) history.get(null, "data");
    sameProjectFlag = ((Boolean) history.get(null, "sameProjectFlag"))
      .booleanValue();
    containerSelectionProjects.getProjectsSelectionA().getCbProjetos()
      .removeAllItems();
    containerSelectionProjects.getProjectsSelectionB().getCbProjetos()
      .removeAllItems();
    RemoteTask<ProjectSynchronizationListProjects> task =
      new RemoteTask<ProjectSynchronizationListProjects>() {
        @Override
        protected void performTask() throws Exception {
          ProjectSynchronizationServiceInterface psi =
            ClientRemoteLocator.projectSynchronizationService;
          ProjectSynchronizationListProjects pslp = psi.buildListProjects(data);
          setResult(pslp);
        }

        @Override
        protected void handleError(Exception e) {
          if (e instanceof ServiceFailureException) {
            StandardErrorDialogs.showErrorDialog(null, "SYNC", e.getMessage());
          }
          else {
            super.handleError(e);
          }
        }
      };
    if (!task.execute(null, getTitle(), registry.getString(
      "step2.getProjectsContents"), 0, RemoteTask.CANCEL_BUTTON)) {
      if (!task.wasCancelled()) {
        Exception re = task.getError();
        error = re.getMessage();
        history.addGlobal("error", error);
      }
      return;
    }
    ProjectSynchronizationListProjects pslp = task.getResult();
    listProjectsServerA = pslp.getProjectsServerA();
    listProjectsServerB = pslp.getProjectsServerB();
    Integer indexA = (Integer) history.get(null, "indexA");
    Integer indexB = (Integer) history.get(null, "indexB");
    populateComboBox(indexA, indexB);

    ItemListener listener = new ItemListener() {
      @Override
      public void itemStateChanged(ItemEvent e) {
        StepSelectionProjects.this.notifyChanged();
      }
    };
    containerSelectionProjects.getProjectsSelectionA().getCbProjetos()
      .addItemListener(listener);
    containerSelectionProjects.getProjectsSelectionB().getCbProjetos()
      .addItemListener(listener);
  }

  private void populateComboBox(Integer indexA, Integer indexB) {
    for (Iterator i = listProjectsServerA.iterator(); i.hasNext();) {
      containerSelectionProjects.getProjectsSelectionA().getCbProjetos()
        .addItem(i.next());
    }
    for (Iterator i = listProjectsServerB.iterator(); i.hasNext();) {
      containerSelectionProjects.getProjectsSelectionB().getCbProjetos()
        .addItem(i.next());
    }
    int sizeA = containerSelectionProjects.getProjectsSelectionA()
      .getCbProjetos().getItemCount();
    int sizeB = containerSelectionProjects.getProjectsSelectionB()
      .getCbProjetos().getItemCount();
    if (indexA == -1 && sizeA > 0) {
      indexA = 0;
    }
    if (indexB == -1 && sizeB > 0) {
      indexB = 0;
    }
    containerSelectionProjects.getProjectsSelectionA().getCbProjetos()
      .setSelectedIndex(indexA);
    containerSelectionProjects.getProjectsSelectionB().getCbProjetos()
      .setSelectedIndex(indexB);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Container getContainer() {
    return containerSelectionProjects.getRootPanel();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected String getInstruction() {
    if (error == null) {
      return registry.getString("instruction.step2");
    }
    return error;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Class getNext(History arg0) {
    return StepSelectionFilesA.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected String getTitle() {
    return registry.getString("title.step2");
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean isReady() {
    if ((getSelectIndexProjectA() > -1) && (getSelectIndexProjectB() > -1)) {
      if (sameProjectFlag) {
        if (getSelectItemProjectNameA().equalsIgnoreCase(
          getSelectItemProjectNameB()) == false) {
          return true;
        }
      }
      else {
        return true;
      }
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void exit(History history) {
    if ((getSelectItemProjectA() != null)
      && (getSelectItemProjectB() != null)) {
      data.getUnitA().setProjectId(getSelectItemProjectA());
      data.getUnitB().setProjectId(getSelectItemProjectB());
      RemoteTask<ProjectSynchronizationData> task =
        new RemoteTask<ProjectSynchronizationData>() {
          @Override
          protected void performTask() throws Exception {
            ProjectSynchronizationServiceInterface psi =
              ClientRemoteLocator.projectSynchronizationService;
            ProjectSynchronizationData psd = psi.buildTransferMaps(data);
            setResult(psd);
          }
        };
      if (!task.execute(null, getTitle(), registry.getString(
        "step2.buildTransferList"), 0, RemoteTask.CANCEL_BUTTON)) {
        if (!task.wasCancelled()) {
          Exception re = task.getError();
          history.addGlobal("error", re.getMessage());
        }
        return;
      }
      data = task.getResult();
      history.addGlobal("data", data);
      history.addGlobal("indexA", new Integer(getSelectIndexProjectA()));
      history.addGlobal("indexB", new Integer(getSelectIndexProjectB()));
      history.addGlobal("projectNameA", getSelectItemProjectNameA());
      history.addGlobal("projectNameB", getSelectItemProjectNameB());
    }
  }
}
