/**
 * $Id$
 */
package csbase.client.applications.serverdiagnostic.monitor;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import csbase.logic.diagnosticservice.DiskStatus;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.StatusCode;

/**
 * Renderer de estado de disco obtidos.
 * 
 * @author Tecgraf
 */
public class DiskRenderer extends DefaultSwingRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public JComponent getHeadline(Status status) {
    return super.getHeadline(status);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public JComponent getDetails(Status status) {
    if (status.getCode() == StatusCode.INITIATING) {
      return createBlankPanel();
    }
    JPanel panel = new JPanel();
    panel.setLayout(new GridBagLayout());
    DiskStatus diskStatus = (DiskStatus) status;
    double freePerc = diskStatus.diskOccupation.getFreeSpacePerc();
    double usedPerc = diskStatus.diskOccupation.getUsedSpacePerc();
    double used = diskStatus.diskOccupation.getUsedSpaceMb();
    double free = diskStatus.diskOccupation.getFreeSpaceMb();
    DecimalFormat df = new DecimalFormat("0.##");
    double totalGB = (used + free) / 1024.;

    JLabel totalLabel =
      new JLabel(getString("DiskRenderer.total.label") + " "
        + df.format(totalGB) + " Gb");
    totalLabel.setHorizontalAlignment(SwingConstants.RIGHT);

    GridBagConstraints c = new GridBagConstraints();
    c.insets = new Insets(0, 0, 1, 0);
    c.gridx = 0;
    c.gridy = 0;
    c.weightx = 0;
    c.weighty = 0;
    c.gridwidth = 1;
    c.gridheight = 1;
    c.fill = GridBagConstraints.NONE;
    c.anchor = GridBagConstraints.NORTHEAST;
    panel.add(totalLabel, c);

    DiskUsagePanel diskPanel = new DiskUsagePanel(usedPerc, freePerc);
    c.insets = new Insets(0, 0, 0, 0);
    c.gridx = 0;
    c.gridy = 1;
    c.weightx = 0;
    c.weighty = 0;
    c.gridwidth = 1;
    c.gridheight = 1;
    c.fill = GridBagConstraints.HORIZONTAL;
    c.anchor = GridBagConstraints.NORTHWEST;
    panel.add(diskPanel, c);

    c.insets = new Insets(0, 0, 0, 0);
    c.gridx = 0;
    c.gridy = 2;
    c.weightx = 1;
    c.weighty = 1;
    c.gridwidth = 1;
    c.gridheight = 1;
    c.fill = GridBagConstraints.BOTH;
    c.anchor = GridBagConstraints.NORTHWEST;
    panel.add(super.getDetails(status), c);
    panel.validate();

    return panel;
  }

  /**
   * Cria um painel em branco para o estado de monitor iniciando.
   * 
   * @return o painel
   */
  private JPanel createBlankPanel() {
    JPanel panel = new JPanel();
    panel.add(new JLabel("O monitor do disco est iniciando"));
    panel.setMinimumSize(new Dimension(250, 50));
    return panel;
  }
}
