package csbase.client.applications.serverdiagnostic.monitor;

import java.awt.Component;
import java.util.Locale;

import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;

import csbase.client.applications.ApplicationImages;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.StatusCode;

/**
 * rvore que exibe os status do painel de monitorao.
 * 
 * @author Tecgraf PUC-Rio
 */
public class StatusTree extends JTree {
  /**
   * Rendered padro da lista.
   */
  private SwingRenderer defaultRenderer;

  /**
   * Construtor
   * 
   * @param locale o local/idioma usado por esse componente
   * @param node o n raiz
   */
  public StatusTree(Locale locale, TreeNode node) {
    super(node);
    defaultRenderer = new DefaultSwingRenderer();
    TreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
    selectionModel.setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    setSelectionModel(selectionModel);
    setShowsRootHandles(true);
    setRootVisible(false);
    DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer() {
      @Override
      public Component getTreeCellRendererComponent(JTree tree, Object value,
        boolean isSelected, boolean isExpanded, boolean isLeaf, int row,
        boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
        StatusNode nodeData = (StatusNode) node.getUserObject();
        JLabel label;
        if (isLeaf) {
          if (nodeData.name != null) {
            label = new JLabel(nodeData.name);
          }
          else {
            Status status = nodeData.status;
            SwingRenderer renderer = defaultRenderer;
            if (renderer == null) {
              label = (JLabel) defaultRenderer.getHeadline(status);
            }
            else {
              label = (JLabel) renderer.getHeadline(status);
            }
          }
          if (isSelected) {
            label.setOpaque(true);
            label.setBackground(getBackgroundSelectionColor());
            label.setForeground(getTextSelectionColor());
          }
          else {
            label.setBackground(getBackgroundNonSelectionColor());
            label.setForeground(getTextNonSelectionColor());
          }
        }
        else {
          label = new JLabel(nodeData.name);
        }
        StatusCode code = StatusCode.UNKNOWN;
        if (isLeaf && nodeData.status != null) {
          code = nodeData.status.getCode();
        }
        else {
          if (StatusGroupTreeNode.class.isInstance(node)) {
            code = StatusGroupTreeNode.class.cast(node).getStatusCode();
          }
        }
        if (code.equals(StatusCode.ERROR)) {
          label.setIcon(ApplicationImages.RED_BALL_16);
        }
        else if (code.equals(StatusCode.WARNING)) {
          label.setIcon(ApplicationImages.YELLOW_BALL_16);
        }
        else {
          label.setIcon(ApplicationImages.GREEN_BALL_16);
        }
        return label;
      }
    };
    setCellRenderer(renderer);
    ToolTipManager.sharedInstance().registerComponent(this);
  }
}
