package csbase.client.applications.sgamonitor.columns;

import java.util.Comparator;

import javax.swing.table.TableCellRenderer;

import csbase.client.applications.sgamonitor.columns.util.JobProcessorPair;
import csbase.client.applications.sgamonitor.columns.util.JobProcessorRenderer;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;

/**
 * Coluna que exibe a soma dos jobs em execuo e a soma de processadores dos
 * ns de um cluster. <br>
 * 
 * @author Tecgraf
 */
public class JobProcessorColumn extends AbstractConfigurableColumn<SGASet> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */
  public JobProcessorColumn(String id, Boolean visible,
    IStringProvider stringProvider, Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return JobProcessorPair.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGASet obj) {

    JobProcessorPair result = new JobProcessorPair(0, 0);

    for (SGAInfo info : obj.getAllInfo()) {
      if (info.getAlive()) {
        result.setJobs(result.getJobs() + info.getNumberOfJobs());
        result.setProcessors(result.getProcessors() + info.getNumProcessors());
      }
    }

    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Comparator<JobProcessorPair> getComparator() {
    return new Comparator<JobProcessorPair>() {
      @Override
      public int compare(JobProcessorPair o1, JobProcessorPair o2) {
        return o1.compareTo(o2);
      }
    };
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return new JobProcessorRenderer();
  }

}
