package csbase.client.applications.sgamonitor.columns.util;

import java.awt.Component;
import java.io.Serializable;

import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * Classe responsvel por renderizar a informao de jobs e processadores de um
 * cluster atravs de uma barra de progresso.
 * 
 * @author Tecgraf
 */
public class JobProcessorRenderer extends JProgressBar implements
  TableCellRenderer, Serializable {

  /**
   * Construtor padro.
   */
  public JobProcessorRenderer() {
    super(0, 100);
    setStringPainted(true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {

    JobProcessorPair jobProcessor = (JobProcessorPair) value;
    setValue(jobProcessor.getFactorAsInt());
    setString(jobProcessor.toString());

    String toolTip = Integer.toString(jobProcessor.getFactorAsInt());
    setToolTipText(toolTip + " %");

    return this;
  }

}