package csbase.client.facilities.configurabletable;

import java.io.Reader;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import csbase.client.facilities.configurabletable.model.Config;

/**
 * Utilitrio que prov operaes que auxiliam a construo de objetos de
 * configurao de tabelas.
 * 
 * @author Tecgraf
 */
public class TableConfigUtil {

  /**
   * Constroi um objeto de configurao de tabelas a partir de um Reader que
   * representa o XML de configurao.
   * 
   * @param reader - objeto que representa o XML de configurao.
   * @return configurao das tabelas.
   */
  public static Config createConfig(Reader reader) {
    try {
      JAXBContext context =
        JAXBContext
          .newInstance("csbase.client.facilities.configurabletable.model");

      Unmarshaller unmarshaller = context.createUnmarshaller();
      Config config = (Config) unmarshaller.unmarshal(reader);
      return config;
    }
    catch (JAXBException e) {
      String message = e.getMessage();
      if (e.getLinkedException() != null) {
        message = e.getLinkedException().getMessage();
      }
      throw new RuntimeException("Erro no XML de configurao:" + message);
    }
  }
}
