/* 
 * $Id$ 
 */
package csbase.client.login;

import java.util.Locale;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.exception.CSBaseException;

/**
 * Classe que implementa as aes especficas para o pr-login
 * @author Tecgraf/PUC-Rio
 */
public class PreLogin implements LoginInterface {
  
  /**
   * Token de indentificao de um usurio 
   */
  private String preLoginToken;
  
  /**
   * O contexto inicial de execuo do cliente.
   */
  private InitialContext initialContext;
  
  /**
   * Cria instncia para tratamento de pr-login 
   * 
   * @param preLoginToken Token de indentificao de um usurio
   * @param initialContext O contexto inicial de execuo do cliente.
   */
  public PreLogin(String preLoginToken, InitialContext initialContext) {
    this.preLoginToken = preLoginToken;
    this.initialContext = initialContext;
  }
  
  /**
   * {@inheritDoc}
   * 
   * Executa o cliente sem solicitar ao usurio que informe login e senha.
   * Entretanto  necessrio que previamente o usurio tenha efetuado um
   * pr-login no sistema em um momento anterior.
   */
  @Override
  public InitialContext login(Locale defaultLocale, String systemName) {    
    ClientRemoteMonitor.getInstance().getServerLookupThread().start();
    try {
      ClientRemoteMonitor.getInstance().start(preLoginToken);
      if (!ClientRemoteMonitor.getInstance().isAlive()) {
        StandardDialogs.showErrorDialog(null, systemName, "Login ou senha invlidos.");
        return null;
      }      
    }
    catch (CSBaseException e) {
      StandardDialogs.showErrorDialog(null, systemName,
          "No foi possvel acessar o servidor. Provavelmente o servidor est fora do ar.");
      e.printStackTrace();
      return null;
    }        
    return initialContext;    
  }


  /**
   * {@inheritDoc}
   * 
   * No faz nada.
   */
  @Override
  public void notifyInitialized() {
  }

  /**
   * {@inheritDoc}
   * 
   * No faz nada.
   */
  @Override
  public void notifyPreInitialization() {
  }

  /**
   * {@inheritDoc}
   * 
   * No faz nada.
   */
  @Override
  public void notifyException(Exception e) {
  }

  /**
   * {@inheritDoc}
   * 
   * Retorna o token como identificador.
   */
  @Override
  public String getClientInstanceId() {
    return "TOKENID:"+preLoginToken;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getFatherClientInstanceId() {
    return null;
  }
}
