/*
 * $Id$
 */
package csbase.client.login;

import java.util.Locale;

import tecgraf.javautils.gui.SwingThreadDispatcher;
import csbase.client.remote.ClientRemoteMonitor;

/**
 * Classe que implementa as aes especficas para o login default. Onde o
 * usurio utiliza dilogo de login.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class UserPasswordLogin implements LoginInterface {

  /**
   * Instncia do dilogo de login
   */
  private final AbstractLoginUI loginUI;

  /**
   * O nome do sistema
   */
  private String systemName;

  /**
   * Consulta o atributo (ver documentao de {@link #systemName}).
   * 
   * @return o atributo.
   */
  public final String getSystemName() {
    return systemName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public InitialContext login(final Locale defaultLocale, final String sysName) {
    this.systemName = sysName;
    return loginUI.execute(defaultLocale);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void notifyException(final Exception e) {
    loginUI.preClientInitializationException();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void notifyInitialized() {
    loginUI.disposeUI();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void notifyPreInitialization() {
    try {
      SwingThreadDispatcher.invokeAndWait(new Runnable() {
        @Override
        public void run() {
          loginUI.preClientInitialization();
        }
      });
    }
    catch (final Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getClientInstanceId() {
    final ClientRemoteMonitor clientRemoteMonitor =
      ClientRemoteMonitor.getInstance();
    final String userLogin = clientRemoteMonitor.getLogin();
    return userLogin + "@" + systemName;
  }

  /**
   * Cria instncia para tratamento do login default
   * 
   * @param loginUI Instncia do dilogo de login
   */
  public UserPasswordLogin(final AbstractLoginUI loginUI) {
    this.loginUI = loginUI;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getFatherClientInstanceId() {
    return null;
  }
}
