/*
 * $Id$
 */
package csbase.client.openbus;

/**
 * @author Tecgraf/PUC-Rio
 */
public abstract class OpenBusEventSource implements OpenBusEventSenderInterface {

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean sendEventWithNoValue(String sourceId, String destId,
    String type) {
    final OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
    final boolean treated =
      oap.getSession().internalSendEventWithNoValue(sourceId, destId, type);
    logSentEvent(treated, sourceId, destId, type, null);
    return treated;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean sendEventWithStringValue(String sourceId, String destId,
    String type, String stringValue) {
    final OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
    final boolean treated =
      oap.getSession().internalSendEventWithStringValue(sourceId, destId, type,
        stringValue);
    logSentEvent(treated, sourceId, destId, type, stringValue);
    return treated;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean sendEventWithBooleanValue(String sourceId, String destId,
    String type, boolean booleanValue) {
    final OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
    final boolean treated =
      oap.getSession().internalSendEventWithBooleanValue(sourceId, destId,
        type, booleanValue);
    return treated;
  }
}
