package csbase.client.preferences.editors;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JComponent;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;

/**
 * Classe que encapsula o editor de um valor booleano.
 * 
 * @author Tecgraf
 */
public class PVBooleanEditor extends PreferenceEditor<Boolean> {

  /**
   * Construtor padro.
   * 
   * @param pv objeto que encapsula o valor da preferncia.
   */
  public PVBooleanEditor(PreferenceValue<Boolean> pv) {
    super(pv);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createComponent() {
    JCheckBox checkBox = new JCheckBox();
    checkBox.setSelected(getValue());
    checkBox.setEnabled(isEditable());

    checkBox.addItemListener(new ItemListener() {
      @Override
      public void itemStateChanged(ItemEvent e) {
        setValue(e.getStateChange() == ItemEvent.SELECTED);
        notifyListeners();
      }
    });

    return checkBox;
  }
}
