/*
 * $Id$
 */

package csbase.client.project;

import java.util.Comparator;

import csbase.logic.ClientProjectFile;

/**
 * Representa um comparador de {@link csbase.client.project.ProjectTreeNode}
 * que utiliza a extenso do n (na verdade, a extenso do arquivo guardado
 * pelo n).
 *
 * @author Tecgraf/PUC-Rio
 */
public final class ProjectTreeNodeExtensionComparator implements Comparator<ProjectTreeNode> {
  /**
   * A instncia
   */
  private static ProjectTreeNodeExtensionComparator instance;

  /**
   * Construtor privado para singleton
   */
  private ProjectTreeNodeExtensionComparator() {}

  /**
   * Obtm a instncia do comparador. Essa instncia  nica.
   *
   * @return A instncia do comparador.
   */
  public static ProjectTreeNodeExtensionComparator getInstance() {
    if (ProjectTreeNodeExtensionComparator.instance == null) {
      ProjectTreeNodeExtensionComparator.instance =
        new ProjectTreeNodeExtensionComparator();
    }
    return ProjectTreeNodeExtensionComparator.instance;
  }

  /**
   * {@inheritDoc}
   */
  public int compare(ProjectTreeNode node1, ProjectTreeNode node2) {
    final ClientProjectFile file1 = node1.getClientProjectFile();
    final ClientProjectFile file2 = node2.getClientProjectFile();
    final boolean d1 = file1.isDirectory();
    final boolean d2 = file2.isDirectory();
    if (d1 != d2) {
      if (d1) return -1;
      else return 1;
    }

    final String ext1 = this.getExtension(file1);
    final String ext2 = this.getExtension(file2);
    final int comparate = ext1.compareTo(ext2);
    if (comparate == 0) {
      final String name1 = file1.getName();
      final String name2 = file2.getName();
      return name1.compareTo(name2);
    }
    return comparate;
  }

  /**
   * Obtm a extenso de um arquivo.
   *
   * @param file O arquivo de onde a extenso ser obtida.
   *
   * @return A extenso do arquivo recebido ou uma string vazia, caso o arquivo
   *         no possua extenso.
   */
  private String getExtension(final ClientProjectFile file) {
    final String name = file.getName();
    final int index = name.lastIndexOf('.');
    if (index == -1) {
      return "";
    }
    return name.substring(index+1);
  }
}
