/*
 * $Id$
 */

package csbase.client.project;

import java.util.Comparator;

import csbase.logic.ClientProjectFile;

/**
 * Representa um comparador de {@link csbase.client.project.ProjectTreeNode}
 * que utiliza o nome do n (na verdade, o nome do arquivo guardado pelo n).
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ProjectTreeNodeNameComparator implements Comparator<ProjectTreeNode> {
  
  /**
   * A instncia
   */
  private static ProjectTreeNodeNameComparator instance;

  /**
   * Construtor privado para singleton
   */
  private ProjectTreeNodeNameComparator() {}

  /**
   * Busca do singleton
   * @return a instncia
   */
  public static ProjectTreeNodeNameComparator getInstance() {
    if (ProjectTreeNodeNameComparator.instance == null) {
      ProjectTreeNodeNameComparator.instance =
        new ProjectTreeNodeNameComparator();
    }
    return ProjectTreeNodeNameComparator.instance;
  }

  /**
   * {@inheritDoc}
   */
  public int compare(ProjectTreeNode node1, ProjectTreeNode node2) {
    final ClientProjectFile file1 = node1.getClientProjectFile();
    final ClientProjectFile file2 = node2.getClientProjectFile();
    final boolean d1 = file1.isDirectory();
    final boolean d2 = file2.isDirectory();
    if (d1 != d2) {
      if (d1) return -1;
      else return 1;
    }
    final String name1 = file1.getName();
    final String name2 = file2.getName();
    return (name1.compareToIgnoreCase(name2));   
  }
}
