/**
 * $Id$
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectBasicInfo;
import csbase.logic.User;

/**
 * Ao para a abertura de um projeto especfico, que pode aparecer como um item
 * de menu de projeto aberto recentemente.
 *
 * @author Tecgraf
 */
public class OneProjectOpenAction extends AbstractAction {

  /**
   * Dados bsicos do projeto aque ser aberto
   */
  private ProjectBasicInfo projectBasicInfo;

  /**
   * Ao para abrir um projeto da lista de projetos abertos recentemente
   * 
   * @param projectBasicInfo Dados do projeto ao qual esta ao de refere
   */
  public OneProjectOpenAction(ProjectBasicInfo projectBasicInfo) {
    this.projectBasicInfo = projectBasicInfo;
    this.putValue(NAME, buildActionText(projectBasicInfo));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent event) {
    DesktopFrame desktop = DesktopFrame.getInstance();
    if (!desktop.checkOpenableProject(projectBasicInfo.getProjectId())) {
      return;
    }
    CommonClientProject project =
      desktop.openProject(projectBasicInfo.getProjectId());
    desktop.setCurrentProject(project);
  }

  /**
   * Cria o texto da ao
   * 
   * @param projectBasicInfo Dados bsicos do projeto
   * @return o texto da ao
   */
  private String buildActionText(ProjectBasicInfo projectBasicInfo) {
    String text = projectBasicInfo.getName();
    User user = User.getLoggedUser();
    if (!projectBasicInfo.getUserId().equals(user.getId())) {
      text += " (" + projectBasicInfo.getUserLogin() + ")";
    }
    return text;
  }

}
