/*
 * $Id$
 */
package csbase.client.project.action;

import java.awt.Window;
import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.RemoteTask;
import csbase.client.facilities.textviewer.TextViewer;
import csbase.client.project.ProjectTree;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;

/**
 * Ao que exibe o histrico de um projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectHistoryShowAction extends ProjectAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    RemoteTask<String> task = new RemoteTask<String>() {
      @Override
      public void performTask() throws Exception {
        final CommonClientProject project = getCurrentProject();
        final ClientProjectFile root = project.getRoot();
        final String description = root.getDescription();
        setResult(description);
      }
    };
    final Window window = getWindow();
    final String taskTitle = getName();
    final String taskMessage = LNG.get("prjhist.msg.waiting_description");
    final boolean executed = task.execute(window, taskTitle, taskMessage);
    if (executed) {
      final String text = task.getResult();
      final String title = LNG.get("prjhist.title");
      final TextViewer textViewer = new TextViewer(text, title);
      textViewer.showDialog();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get("prjhist.action");
  }

  /**
   * Construtor
   * 
   * @param treeView a rvore
   */
  public ProjectHistoryShowAction(ProjectTree treeView) {
    super(treeView);
  }
}
