/*
 * $Id$
 */
package csbase.client.project.tasks;

import csbase.logic.ClientProjectFile;

/**
 * Classe que implementa a tarefa de consultar os filhos de um diretrio em um
 * projeto.
 */
public class GetChildFromNameTask extends CoreTask<ClientProjectFile> {

  /**
   * Arquivo consultado.
   */
  final private ClientProjectFile clientProjectFile;

  /**
   * O path nome
   */
  final private String childName;

  /**
   * Construtor.
   * 
   * @param clientProjectFile o arquivo consultado.
   * @param childName o nome do arquivo buscado (como filho de
   *        {@link #clientProjectFile}).
   */
  public GetChildFromNameTask(ClientProjectFile clientProjectFile,
    final String childName) {
    this.clientProjectFile = clientProjectFile;
    this.childName = childName;
  }

  /**
   * {@inheritDoc}
   * 
   * Faz a chamada remota a getChild (lado cliente).
   */
  @Override
  protected void performTask() throws Exception {
    ClientProjectFile file = clientProjectFile.getChild(childName);
    setResult(file);
  }

  /**
   * Mtodo de convenincia para chamada automtica da task.
   * 
   * @param parent diretrio pai.
   * @param childName nome do arquivo (diretrio) filho.
   * @return o arquivo ou null
   */
  static final public ClientProjectFile runTask(final ClientProjectFile parent,
    final String childName) {
    final GetChildFromNameTask task =
      new GetChildFromNameTask(parent, childName);
    final boolean hasResult = task.execute();
    if (!hasResult) {
      return null;
    }
    final ClientProjectFile result = task.getResult();
    return result;
  }
}
