/*
 * DateTranslator.java $Author$ $Revision$ - $Date:
 * 2005-11-09 14:32:03 -0200 (Wed, 09 Nov 2005) $
 */
package csbase.client.util;

import java.text.MessageFormat;
import java.util.Date;

import tecgraf.javautils.core.lng.LNG;

/**
 * Singleton do tradutor de notificaes vindas do serivdor.
 */
public class DateTranslator {
  /** Instncia do tradutor */
  private static DateTranslator instance = null;

  /**
   * Traduo de uma data no formato adequado Retorna uma string de lixo para
   * depurao.
   * 
   * @param date um objeto do tipo <code>Date</code>
   * 
   * @return uma string formatada
   */
  public String translate(Date date) {
    final String format = LNG.get("DATE_TRANSLATOR");
    final MessageFormat formatter = new MessageFormat(format);
    Object[] args = new Date[] { date };
    StringBuffer text = new StringBuffer();
    formatter.format(args, text, null);
    return text.toString();
  }

  /**
   * Retorna a instncia do tradutor de datas
   * 
   * @return o tradutor
   */
  public static DateTranslator getInstance() {
    if (instance == null) {
      instance = new DateTranslator();
    }
    return instance;
  }
}
