package csbase.client.util.charset;

import java.awt.Component;
import java.nio.charset.Charset;
import java.util.List;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

import tecgraf.javautils.gui.ComboUtil;
import csbase.client.Client;

/**
 * Combo com a lista de charsets padronizados conforme a lista definida em:
 * {@code StandardCharsets}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CharsetComboBox extends JComboBox {

  /**
   * Construtor
   */
  public CharsetComboBox() {
    this(StandardCharsets.getInstance().getAllStandardCharsets());
  }

  /**
   * Construtor
   * 
   * @param charsets lista de charsets a serem usados.
   */
  public CharsetComboBox(List<Charset> charsets) {
    final Client client = Client.getInstance();
    final Charset sysCharset = client.getSystemDefaultCharset();
    ComboUtil.updateFromList(this, charsets, 0);
    if (charsets.contains(sysCharset)) {
      setSelectedItem(sysCharset);
    }

    final DefaultListCellRenderer rnd = new DefaultListCellRenderer() {
      @Override
      public Component getListCellRendererComponent(JList list, Object value,
        int index, boolean isSelected, boolean cellHasFocus) {
        final JLabel cmp =
          (JLabel) super.getListCellRendererComponent(list, value, index,
            isSelected, cellHasFocus);
        final Charset charset = (Charset) value;
        final StandardCharsets stdCharsets = StandardCharsets.getInstance();
        final String chName = stdCharsets.getLegibleName(charset);
        cmp.setText(chName);
        return cmp;
      }
    };
    setRenderer(rnd);
  }

  /**
   * Consulta o charset selecionado.
   * 
   * @return o charset selecionado.
   */
  final public Charset getSelectedCharset() {
    final Charset ch = (Charset) getSelectedItem();
    return ch;
  }
}
