package csbase.client.util.csvpanel.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.csvpanel.table.CSVTable;
import csbase.client.util.csvpanel.table.CSVTableModel;

/**
 * Menu popup do cabealho da linha da tabela, que permite a insero/remoo de
 * linhas na mesma.
 * 
 * @author Tecgraf
 */
public class RowHeaderPopupMenu extends CSVTablePopupMenu {

  /**
   * Item de adio de nova linha antes da linha selecionada.
   */
  private JMenuItem addRowBeforeItem;
  /**
   * Item de adio de nova linha aps a linha selecionada.
   */
  private JMenuItem addRowAfterItem;
  /**
   * Item de remoo da linha selecionada.
   */
  private JMenuItem removeRowItem;

  /**
   * Item de duplicao da linha selecionada.
   */
  private JMenuItem duplicateRowItem;

  /**
   * Construtor.
   * 
   * @param table a tabela CSV.
   */
  public RowHeaderPopupMenu(CSVTable table) {
    super(table);
    createMenu();
  }

  /**
   * Cria o contedo do menu.
   */
  private void createMenu() {
    String addRowBeforeLabel = getString("addRowBefore.item");
    addRowBeforeItem =
      new JMenuItem(addRowBeforeLabel,
        ApplicationImages.ICON_ROWINSERTBEFORE_16);
    addRowBeforeItem.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        CSVTableModel model = table.getModel();
        model.addRow(popupRow);
      }
    });
    add(addRowBeforeItem);
    String addRowAfterLabel = getString("addRowAfter.item");
    addRowAfterItem =
      new JMenuItem(addRowAfterLabel, ApplicationImages.ICON_ROWINSERTAFTER_16);
    addRowAfterItem.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        CSVTableModel model = table.getModel();
        model.addRow(popupRow + 1);
      }
    });
    add(addRowAfterItem);
    String removeRowLabel = getString("removeRow.item");
    removeRowItem =
      new JMenuItem(removeRowLabel, ApplicationImages.ICON_ROWDELETE_16);
    removeRowItem.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        CSVTableModel model = table.getModel();
        model.removeRow(popupRow);
      }
    });
    add(removeRowItem);

    String duplicateRowLabel = getString("duplicateRow.item");
    duplicateRowItem =
      new JMenuItem(duplicateRowLabel, ApplicationImages.ICON_ROWDUPLICATE_16);
    duplicateRowItem.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        CSVTableModel model = table.getModel();
        model.duplicateRow(popupRow);
      }
    });
    add(duplicateRowItem);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean shouldBeShown() {
    return super.shouldBeShown() && table.isEditable();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void updateItemStatus() {
    removeRowItem.setEnabled(table.getRowCount() > 1);
  }
}
