/*
 * $Id$
 */
package csbase.client.util.gui.log.actions;

import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.event.EventListener;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.LogPanel.PagingEvent;
import csbase.client.util.gui.log.actions.core.AbstractLogFileAction;

/**
 * Pede para que o painel de log mostre a pgina seguinte. Caso a pgina sendo
 * mostrada pelo painel seja a ltima, esta ao se desabilita.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class IncPageAction extends AbstractLogFileAction {

  /**
   * Construtor
   * 
   * @param logPanel o painel de log associado a ao.
   */
  public IncPageAction(final LogPanel logPanel) {
    super(logPanel, ApplicationImages.ICON_PAGE_INC_16);
    logPanel.addPagingEventListener(new EventListener<LogPanel.PagingEvent>() {
      public void eventFired(PagingEvent event) {
        long page = event.getPageNumber();
        long pagesCount = event.countPages();
        if (pagesCount <= page) {
          setEnabled(false);
        }
        else {
          setEnabled(true);
        }
      }      
    });    
  }
  
  /**
   * {@inheritDoc}
   */  
  @Override
  public void actionDone(JComponent component) throws Exception {
    long page = getLogPanel().getPageNumber();
    long nextPage = page + 1;    
    getLogPanel().goToPage(nextPage);
    if (getLogPanel().countPages() == nextPage) {
      getLogPanel().getTextArea().goToTail();
    }
  }
}

