/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.diskinfo;

import csbase.client.applications.Application;
import csbase.client.applications.diskinfo.DiskInfoPanel;
import csbase.client.remote.srvproxies.DiskUsageProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;
import tecgraf.javautils.core.lng.LNG;

public class DiskUserPanel
extends DiskInfoPanel {
    private final boolean showsNoSpaceUser;
    private final JFreeChart graph;

    @Override
    public final void rotatePie() {
        PiePlot pieplot = (PiePlot)this.graph.getPlot();
        double angle = pieplot.getStartAngle() + 1.0;
        pieplot.setStartAngle(angle);
        if (angle == 360.0) {
            angle = 0.0;
        }
    }

    @Override
    public final void refreshPie(Application app) {
        Hashtable<Object, Double> hash = DiskUsageProxy.getUsersList();
        DefaultPieDataset dataset = new DefaultPieDataset();
        boolean emptyProjects = true;
        if (hash != null) {
            Enumeration<Object> en = hash.keys();
            while (en.hasMoreElements()) {
                Object id = en.nextElement();
                double mega = hash.get(id);
                if (!(mega > 0.0) && !this.showsNoSpaceUser) continue;
                dataset.setValue((Comparable)((Object)id.toString()), mega);
                emptyProjects = false;
            }
        }
        if (emptyProjects) {
            dataset.setValue((Comparable)((Object)""), 0.0);
        }
        PiePlot pieplot = (PiePlot)this.graph.getPlot();
        pieplot.setNoDataMessage(app.getString("DiskUserPanel.get.usage.failed.error"));
        String labelFmt = app.getString("panel.user.label.format");
        NumberFormat sizeFormatter = NumberFormat.getNumberInstance(LNG.getLocale());
        sizeFormatter.setMinimumFractionDigits(2);
        sizeFormatter.setMaximumFractionDigits(2);
        NumberFormat percFormatter = NumberFormat.getPercentInstance();
        pieplot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(labelFmt, sizeFormatter, percFormatter));
        pieplot.setDirection(Rotation.CLOCKWISE);
        pieplot.setForegroundAlpha(0.7f);
        pieplot.setBackgroundPaint(null);
        pieplot.setOutlinePaint(null);
        pieplot.setDataset((PieDataset)dataset);
        pieplot.setCircular(true);
    }

    public DiskUserPanel(Application app) {
        String name = app.getString("panel.user.disk");
        String tabName = app.getString("panel.user.disk.tab");
        this.graph = ChartFactory.createPieChart3D((String)name, null, (boolean)false, (boolean)false, (boolean)false);
        ChartPanel chartPanel = new ChartPanel(this.graph);
        chartPanel.setPopupMenu(null);
        this.setLayout(new BorderLayout());
        this.add((Component)chartPanel, "Center");
        this.setName(tabName);
        this.showsNoSpaceUser = app.getBooleanSpecificProperty("showsNoSpaceUsers", true);
        this.refreshPie(app);
    }
}

