/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication;

import csbase.client.applications.flowapplication.NodeCallback;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import tecgraf.javautils.gui.tree.Node;

public class TreeUtil {
    private static TreePath hasObject(JTree tree, TreePath parentPath, Node node, Object object) {
        if (node.equals(object) && node.getParent().equals(((Node)object).getParent())) {
            return parentPath.pathByAddingChild(node);
        }
        TreePath path = parentPath.pathByAddingChild(node);
        for (Node childNode : node.getChildren()) {
            TreePath tpath = TreeUtil.hasObject(tree, path, childNode, object);
            if (tpath == null) continue;
            return tpath;
        }
        return null;
    }

    private static TreePath hasRootObject(JTree tree, Object object) {
        TreeModel model = tree.getModel();
        Node root = (Node)model.getRoot();
        TreePath rootPath = new TreePath(root);
        for (Node node : root.getChildren()) {
            TreePath tpath = TreeUtil.hasObject(tree, rootPath, node, object);
            if (tpath == null) continue;
            return tpath;
        }
        return null;
    }

    public static void load(JTree tree, List<Object> vector) {
        for (Object object : vector) {
            TreePath path = TreeUtil.hasRootObject(tree, object);
            if (path == null) continue;
            tree.collapsePath(path);
        }
    }

    public static void processNodes(JTree tree, NodeCallback callback) {
        Node root = (Node)tree.getModel().getRoot();
        TreePath rootPath = new TreePath(root);
        callback.preProcess(tree, null, root);
        if (root.getChildren().size() >= 0) {
            Iterator iterator = root.getChildren().iterator();
            while (iterator.hasNext()) {
                Node e;
                Node node = e = (Node)iterator.next();
                TreeUtil.visitNodes(tree, rootPath, node, callback);
            }
        }
        callback.postProcess(tree, null, root);
    }

    public static List<Object> save(JTree tree) {
        final ArrayList<Object> vector = new ArrayList<Object>();
        NodeCallback callback = new NodeCallback(){

            @Override
            public final void postProcess(JTree t, TreePath parentPath, Node node) {
                TreePath path = parentPath == null ? new TreePath(node) : parentPath.pathByAddingChild(node);
                if (!t.isExpanded(path)) {
                    vector.add(node);
                }
            }
        };
        TreeUtil.processNodes(tree, callback);
        return vector;
    }

    private static void visitNodes(JTree tree, TreePath parentPath, Node node, NodeCallback callback) {
        callback.preProcess(tree, parentPath, node);
        TreePath path = parentPath.pathByAddingChild(node);
        if (node.getChildren().size() >= 0) {
            Iterator iterator = node.getChildren().iterator();
            while (iterator.hasNext()) {
                Node e;
                Node childNode = e = (Node)iterator.next();
                TreeUtil.visitNodes(tree, path, childNode, callback);
            }
        }
        callback.postProcess(tree, parentPath, node);
    }
}

