/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.tasks;

import csbase.client.project.tasks.CoreTask;
import csbase.exception.CSBaseRuntimeException;
import csbase.logic.CommonClientProject;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.rmi.RemoteException;

public class CreateDirectoryPathTask
extends CoreTask<Void> {
    private final CommonClientProject project;
    private final String[] dirPath;
    private ErrorCode errorCode = ErrorCode.NOT_EXECUTED;

    public CreateDirectoryPathTask(CommonClientProject project, String[] dirPath) {
        this.project = project;
        this.dirPath = dirPath;
    }

    protected void performTask() throws Exception {
        if (ClientRemoteLocator.projectService.existsFile(this.project.getId(), this.dirPath)) {
            return;
        }
        this.project.createDirectory(this.project.getRoot(), this.dirPath);
        this.errorCode = ErrorCode.NO_ERROR;
    }

    @Override
    protected void handleError(Exception error) {
        if (error instanceof RemoteException) {
            super.handleError(error);
            this.errorCode = ErrorCode.RMI_FAILURE;
        } else if (error instanceof CSBaseRuntimeException) {
            super.handleError(error);
            this.errorCode = ErrorCode.RUNTIME_EXCEPTION;
        } else {
            this.errorCode = ErrorCode.UNKNOWN;
        }
        this.setResult(null);
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public static final boolean runTask(Window window, CommonClientProject project, String[] dirPath) {
        CreateDirectoryPathTask task = new CreateDirectoryPathTask(project, dirPath);
        return task.execute(window, new String[]{project.getName()});
    }

    public static enum ErrorCode {
        NOT_EXECUTED,
        NO_ERROR,
        RUNTIME_EXCEPTION,
        RMI_FAILURE,
        UNKNOWN;

    }
}

