/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser;

import csbase.client.ClientLocalFile;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.DirectoryCreationDialog;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.filechooser.ClientFileChooserActionListener;
import csbase.client.util.filechooser.ClientFileChooserCardinality;
import csbase.client.util.filechooser.ClientFileChooserSelectionListener;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.client.util.filechooser.fileparentcombopanel.ClientFileParentComboChooseListener;
import csbase.client.util.filechooser.fileparentcombopanel.ClientFileParentComboPanel;
import csbase.client.util.filechooser.filetablepanel.ClientFileTablePanel;
import csbase.client.util.filechooser.filters.ClientFileAllFilter;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface;
import csbase.client.util.filechooser.images.ChooserImages;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.exception.BugException;
import csbase.exception.PermissionException;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;
import csbase.logic.ClientProjectFile;
import csbase.logic.ClientSGAFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileType;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.ComboUtil;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public class ClientFileChooser
extends JDialog {
    private static final String MULTIPLE_PATHS_SEPARATOR = ";";
    private final JButton cancelButton = new JButton();
    private final JToggleButton filterToggle = new JToggleButton();
    private List<ClientFile> chosenItens = null;
    private final JComboBox filterCombo = new JComboBox();
    private final JButton localHomeDirButton = new JButton();
    private final ClientFileParentComboPanel hierarchyCombo = new ClientFileParentComboPanel();
    private final JLabel hierarchyLabel = new JLabel();
    private final JButton localRootDirButton = new JButton();
    private final JButton okButton = new JButton();
    private final JButton newDirectoryAction = new JButton();
    private final JButton projHomeDirButton = new JButton();
    private String[] selectedSavePath = null;
    private final JTextField selectionText = new JTextField();
    private final ClientFileTablePanel tablePanel = new ClientFileTablePanel();
    private ClientFileChooserType type;
    List<ClientFileFilterInterface> viewFilters = new ArrayList<ClientFileFilterInterface>();

    private String[] appendPath(String[] baseDir, String[] relativePath) {
        int dirLenght = baseDir.length;
        String[] dir = baseDir;
        if (dirLenght == 0) {
            dir = new String[]{""};
            ++dirLenght;
        }
        String[] path = new String[dirLenght + relativePath.length];
        System.arraycopy(dir, 0, path, 0, dirLenght);
        System.arraycopy(relativePath, 0, path, dirLenght, relativePath.length);
        return path;
    }

    private JPanel buildButtonsPanel() {
        AbstractAction cancelAction = this.createCancelAction();
        this.cancelButton.setAction(cancelAction);
        AbstractAction okAction = this.createOkAction();
        this.okButton.setAction(okAction);
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{this.cancelButton, this.okButton});
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1));
        panel.add(this.cancelButton);
        panel.add(this.okButton);
        return panel;
    }

    private AbstractAction createCancelAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFileChooser.this.handleCancelButton();
            }
        };
        int esc = 27;
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        action.putValue("AcceleratorKey", stroke);
        this.setKeyStroke(action, stroke);
        String text = this.getString("cancel.button", new Object[0]);
        action.putValue("Name", text);
        return action;
    }

    private void setKeyStroke(AbstractAction action, KeyStroke stroke) {
        boolean mode = true;
        InputMap inputMap = this.rootPane.getInputMap(1);
        ActionMap actionMap = this.rootPane.getActionMap();
        String actionMapKey = stroke.toString();
        inputMap.put(stroke, actionMapKey);
        actionMap.put(actionMapKey, action);
    }

    private AbstractAction createOkAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFileChooser.this.handleOkButton();
            }
        };
        String text = this.getString("ok.button", new Object[0]);
        action.putValue("Name", text);
        return action;
    }

    private JPanel buildSelectionPanel() {
        JLabel selectionLabel = new JLabel();
        selectionLabel.setText(this.getString("selection.label", new Object[0]));
        this.selectionText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ClientFileChooser.this.okButton.doClick();
            }
        });
        this.selectionText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                boolean isLetterOrDigit;
                char c = e.getKeyChar();
                boolean acceptKey = true;
                if (c == '\\') {
                    acceptKey = false;
                } else if (ClientFileChooser.this.getClientFileType() == ClientFileType.REMOTE && !(isLetterOrDigit = Character.isLetterOrDigit(c)) && c != '_' && c != '.' && c != '/') {
                    acceptKey = false;
                }
                if (!acceptKey) {
                    Toolkit toolkit = ClientFileChooser.this.getToolkit();
                    toolkit.beep();
                    e.consume();
                }
            }
        });
        JLabel filterLabel = new JLabel();
        filterLabel.setText(this.getString("filter.label", new Object[0]));
        this.filterCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ClientFileFilterInterface filter = (ClientFileFilterInterface)value;
                this.setText(filter.getDescription());
                this.setIcon(filter.getImageIcon());
                this.setFont(this.getFont().deriveFont(0));
                return this;
            }
        });
        this.filterCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFileFilterInterface flt = ClientFileChooser.this.getCurrentViewFilter();
                ClientFileChooser.this.internalSetViewFilter(flt);
            }
        });
        JComponent[][] components = new JComponent[][]{{selectionLabel, this.selectionText}, {filterLabel, this.filterCombo}};
        JPanel panel = GUIUtils.createBasicGridPanel((JComponent[][])components);
        return panel;
    }

    private JPanel buildToolPanel() {
        AbstractAction filterAction = this.createFilterAction();
        this.filterToggle.setAction(filterAction);
        AbstractAction refreshAction = this.createRefreshAction();
        JButton refreshButton = new JButton(refreshAction);
        AbstractAction upDirAction = this.createUpDirAction();
        JButton upDirButton = new JButton(upDirAction);
        AbstractAction createNewDirAction = this.createNewDirectoryAction();
        this.newDirectoryAction.setAction(createNewDirAction);
        AbstractAction projectHomeDirAction = this.createProjectHomeDirAction();
        this.projHomeDirButton.setAction(projectHomeDirAction);
        AbstractAction localHomeDirAction = this.createLocalHomeDirAction();
        this.localHomeDirButton.setAction(localHomeDirAction);
        AbstractAction localRootDirAction = this.createLocalRootDirAction();
        this.localRootDirButton.setAction(localRootDirAction);
        JPanel hierarchyPanel = this.buildHierarchyPanel();
        JToolBar toolbar = new JToolBar(0);
        toolbar.setFloatable(false);
        toolbar.addSeparator();
        toolbar.add(this.filterToggle);
        toolbar.add(refreshButton);
        toolbar.addSeparator();
        toolbar.add(upDirButton);
        toolbar.addSeparator();
        toolbar.add(this.newDirectoryAction);
        toolbar.add(this.projHomeDirButton);
        toolbar.add(this.localHomeDirButton);
        toolbar.add(this.localRootDirButton);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)hierarchyPanel, new GBC(0, 0).horizontal());
        panel.add((Component)toolbar, new GBC(1, 0).none());
        return panel;
    }

    private JPanel buildHierarchyPanel() {
        ClientFileParentComboChooseListener comboChooseListener = new ClientFileParentComboChooseListener(){

            @Override
            public void parentChosen(ClientFileParentComboPanel panel, ClientFile object) {
                if (object == null) {
                    return;
                }
                ClientFileChooser.this.setCurrentDirectory(object);
                ClientFileChooser.this.refresh();
            }
        };
        this.hierarchyCombo.addParentsComboPanelChooseListener(comboChooseListener);
        String hierarchyText = this.getString("hierarchy.label", new Object[0]);
        this.hierarchyLabel.setText(hierarchyText);
        JComponent[][] components = new JComponent[][]{{this.hierarchyLabel, this.hierarchyCombo}};
        JPanel hPanel = GUIUtils.createBasicGridPanel((JComponent[][])components);
        return hPanel;
    }

    private AbstractAction createFilterAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFileChooser.this.showHiddenFiles(!ClientFileChooser.this.isHiddenFilesShown());
            }
        };
        ImageIcon icon = ChooserImages.FILTER_HIDDEN_IMG;
        action.putValue("SmallIcon", icon);
        String tooltip = this.getString("filter.hidden.tooltip", new Object[0]);
        action.putValue("ShortDescription", tooltip);
        int fKey = 70;
        KeyStroke stroke = KeyStroke.getKeyStroke(70, 2);
        action.putValue("AcceleratorKey", stroke);
        this.setKeyStroke(action, stroke);
        return action;
    }

    private AbstractAction createLocalHomeDirAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFileChooser.this.setLocalHomeDirectory();
            }
        };
        ImageIcon icon = ChooserImages.LOCAL_HOME_ICON;
        action.putValue("SmallIcon", icon);
        String tooltip = this.getString("home.tooltip", new Object[0]);
        action.putValue("ShortDescription", tooltip);
        return action;
    }

    private AbstractAction createUpDirAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFileChooser.this.setUpDirectory();
            }
        };
        ImageIcon icon = ChooserImages.PARENT_FOLDER_IMG;
        action.putValue("SmallIcon", icon);
        String tooltip = this.getString("up.tooltip", new Object[0]);
        action.putValue("ShortDescription", tooltip);
        int up = 38;
        KeyStroke stroke = KeyStroke.getKeyStroke(38, 8);
        action.putValue("AcceleratorKey", stroke);
        this.setKeyStroke(action, stroke);
        return action;
    }

    private AbstractAction createProjectHomeDirAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFileChooser.this.setProjectHomeDirectory();
            }
        };
        ImageIcon icon = ChooserImages.PROJECT_HOME_ICON;
        action.putValue("SmallIcon", icon);
        String tooltip = this.getString("project.tooltip", new Object[0]);
        action.putValue("ShortDescription", tooltip);
        return action;
    }

    private AbstractAction createNewDirectoryAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryCreationDialog.show(ClientFileChooser.this.getOwner(), ClientFileChooser.this.getCurrentDirectory());
                ClientFileChooser.this.refresh();
            }
        };
        ImageIcon icon = ChooserImages.NEW_DIRECTORY_ICON;
        action.putValue("SmallIcon", icon);
        String tooltip = this.getString("new.dir.tooltip", new Object[0]);
        action.putValue("ShortDescription", tooltip);
        return action;
    }

    private AbstractAction createLocalRootDirAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFileChooser.this.setLocalRootDirectory();
            }
        };
        ImageIcon icon = ChooserImages.LOCAL_ROOT_ICON;
        action.putValue("SmallIcon", icon);
        String tooltip = this.getString("root.tooltip", new Object[0]);
        action.putValue("ShortDescription", tooltip);
        return action;
    }

    private AbstractAction createRefreshAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFileChooser.this.refresh();
            }
        };
        String refreshToolTip = this.getString("refresh.tooltip", new Object[0]);
        action.putValue("ShortDescription", refreshToolTip);
        ImageIcon icon = ApplicationImages.ICON_REFRESH_16;
        action.putValue("SmallIcon", icon);
        int f5 = 116;
        KeyStroke stroke = KeyStroke.getKeyStroke(116, 0);
        action.putValue("AcceleratorKey", stroke);
        this.setKeyStroke(action, stroke);
        return action;
    }

    private boolean areTypesMatched(String fileName) {
        if (fileName != null && !fileName.isEmpty()) {
            ProjectFileType fltType;
            boolean isDirectory;
            String fileExtension = FileUtils.getFileExtension((String)fileName);
            switch (this.getSelectionMode()) {
                case DIRECTORIES_ONLY: {
                    isDirectory = true;
                    break;
                }
                case FILES_ONLY: {
                    isDirectory = false;
                    break;
                }
                default: {
                    String msg = String.format("O modo %s n\u00e3o foi tratado.", new Object[]{this.getSelectionMode()});
                    throw new BugException(msg);
                }
            }
            ProjectFileType extType = ProjectFileType.getProjectFileTypeFromExtension((String)fileExtension, (boolean)isDirectory);
            if (this.getSelectionType() == ClientFileChooserType.SAVE && (fltType = this.getFileTypeFromSelectedFilter()) != null && extType != null && !extType.equals((Object)fltType)) {
                String fltDesc = fltType.getDescription();
                String extDesc = extType.getDescription();
                String tag = "diff.types.extension.confirmation";
                String fltCode = fltType.getCode();
                String extCode = extType.getCode();
                String title = this.getTitle();
                String msg = this.getString("diff.types.extension.confirmation", fileName, fltCode, fltDesc, extCode, extDesc);
                int op = StandardDialogs.showYesNoDialog((Component)this, (String)title, (Object)msg);
                return op == 0;
            }
        }
        return true;
    }

    private boolean canCloseAsUserConfirmedOverwrite(String[] stringPath) {
        String path = FileUtils.joinPath((String[])stringPath);
        String title = this.getTitle();
        String tag = "overwrite.confirmation";
        String msg = this.getString("overwrite.confirmation", path);
        int op = StandardDialogs.showYesNoDialog((Component)this, (String)title, (Object)msg);
        return op == 0;
    }

    void clearSelectionText() {
        this.selectionText.setText(null);
    }

    public void closeOnSingleFile(ClientFile selected) {
        ArrayList<ClientFile> chosen = new ArrayList<ClientFile>();
        chosen.add(selected);
        this.setChosenItens(chosen);
        this.selectedSavePath = selected.getPath();
        this.handleOkButton();
    }

    private void die() {
        this.selectedSavePath = null;
        this.chosenItens = null;
        this.clearSelectionText();
        this.filterCombo.setEnabled(false);
        this.filterCombo.setModel(new DefaultComboBoxModel());
        this.hierarchyCombo.setLeafDirectory(null);
        this.hierarchyCombo.setEnabled(false);
        this.setVisible(false);
    }

    public void enableOkButton(boolean flag) {
        this.okButton.setEnabled(flag);
    }

    void enableSelectionText(boolean flag) {
        this.selectionText.setEditable(flag);
    }

    public final ClientFileChooserCardinality getCardinality() {
        return this.tablePanel.getCardinality();
    }

    public final List<ClientFile> getChosenItens() {
        return this.chosenItens;
    }

    public final ClientFile getCurrentDirectory() {
        ClientFile rootObject = this.tablePanel.getRootDirectory();
        if (rootObject == null) {
            return null;
        }
        return rootObject;
    }

    public final ClientFileFilterInterface getCurrentViewFilter() {
        Object selected = this.filterCombo.getSelectedItem();
        ClientFileFilterInterface flt = (ClientFileFilterInterface)selected;
        return flt;
    }

    public final ProjectFileType getFileTypeFromFileName(String fileName) {
        boolean isDirectory;
        switch (this.getSelectionMode()) {
            case DIRECTORIES_ONLY: {
                isDirectory = true;
                break;
            }
            case FILES_ONLY: {
                isDirectory = false;
                break;
            }
            default: {
                String message = String.format("O modo %s n\u00e3o foi tratado.", new Object[]{this.getSelectionMode()});
                throw new BugException(message);
            }
        }
        String extension = FileUtils.getFileExtension((String)fileName);
        ProjectFileType tp = ProjectFileType.getProjectFileTypeFromExtension((String)extension, (boolean)isDirectory);
        return tp;
    }

    public final ProjectFileType getFileTypeFromSelectedFilter() {
        ClientFileFilterInterface filter = this.getSelectedFilter();
        if (filter != null && filter.inferFileType() != null) {
            return filter.inferFileType();
        }
        return null;
    }

    private CommonClientProject getProjectOrDie() {
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        if (desktopFrame == null) {
            String tag = "no.desktop.detected.error";
            String msg = this.getString("no.desktop.detected.error", new Object[0]);
            this.showErrorMessage(msg);
            this.die();
            return null;
        }
        CommonClientProject project = desktopFrame.getProject();
        if (project == null) {
            String tag = "no.project.detected.error";
            String msg = this.getString("no.project.detected.error", new Object[0]);
            this.showErrorMessage(msg);
            this.die();
        }
        return project;
    }

    public final ClientFileFilterInterface getSelectedFilter() {
        Object selected = this.filterCombo.getSelectedItem();
        return (ClientFileFilterInterface)selected;
    }

    public final void setSelectedFilter(ClientFileFilterInterface filter) {
        this.filterCombo.setSelectedItem(filter);
    }

    public final String[] getSelectedSavePath() {
        return this.selectedSavePath;
    }

    public final String getSelectedSavePath(String sep) {
        String result = "";
        if (this.selectedSavePath == null) {
            return null;
        }
        int length = this.selectedSavePath.length;
        for (int i = 0; i < length - 1; ++i) {
            result = result + this.selectedSavePath[i] + sep;
        }
        String fileName = this.selectedSavePath[length - 1];
        return result + fileName;
    }

    public final ClientFileChooserSelectionMode getSelectionMode() {
        return this.tablePanel.getSelectionMode();
    }

    public final ClientFileChooserType getSelectionType() {
        return this.type;
    }

    private final String getString(String tag, Object ... args) {
        String prefix = this.getClass().getSimpleName();
        String fmt = LNG.get((String)(prefix + "." + tag));
        String text = String.format(fmt, args);
        return text;
    }

    public final List<ClientFileFilterInterface> getViewFilters() {
        ArrayList<ClientFileFilterInterface> list = new ArrayList<ClientFileFilterInterface>();
        list.addAll(this.viewFilters);
        Collections.unmodifiableList(list);
        return list;
    }

    private void handleCancelButton() {
        this.setChosenItens(null);
        this.selectedSavePath = null;
        this.setVisible(false);
    }

    private void handleOkButton() {
        boolean isToClose;
        ClientFileChooserType tp = this.getSelectionType();
        switch (tp) {
            case SAVE: {
                isToClose = this.handleOkSaveType();
                break;
            }
            case OPEN: {
                isToClose = this.handleOkOpenType();
                break;
            }
            default: {
                isToClose = false;
            }
        }
        this.setVisible(!isToClose);
    }

    private boolean handleOkOpenType() {
        block13: {
            String selectedText = this.selectionText.getText();
            if (selectedText.trim().isEmpty()) break block13;
            String[] paths = this.parsePaths(selectedText);
            ArrayList<ClientFile> selectedFiles = new ArrayList<ClientFile>();
            ClientFile parent = null;
            for (String path : paths) {
                ClientFile selectedFile;
                block15: {
                    ClientFileChooserSelectionMode selectionMode;
                    block14: {
                        selectedFile = this.getFileFromPath(path);
                        if (selectedFile == null) continue;
                        String fileName = selectedFile.getName();
                        if (!this.areTypesMatched(fileName)) {
                            return false;
                        }
                        selectionMode = this.getSelectionMode();
                        ClientFileFilterInterface filter = this.getSelectedFilter();
                        if (!selectedFile.isDirectory()) break block14;
                        switch (selectionMode) {
                            case FILES_ONLY: {
                                this.setCurrentDirectory(selectedFile);
                                return false;
                            }
                            case DIRECTORIES_ONLY: {
                                if (!filter.accept(selectedFile, ClientFileFilterInterface.Operation.SELECTION)) {
                                    this.setCurrentDirectory(selectedFile);
                                    return false;
                                }
                                break block15;
                            }
                            default: {
                                String msg = String.format("Modo inv\u00e1lido: %s.", new Object[]{selectionMode});
                                throw new IllegalStateException(msg);
                            }
                        }
                    }
                    if (selectionMode == ClientFileChooserSelectionMode.DIRECTORIES_ONLY) {
                        String tag = "not.dir.error";
                        String msg = this.getString("not.dir.error", selectedFile.getName());
                        this.showErrorMessage(msg);
                        return false;
                    }
                }
                if (parent == null) {
                    parent = selectedFile.getParent();
                } else if (!parent.equals(selectedFile.getParent())) {
                    String tag = "different.parent.error";
                    String msg = this.getString("different.parent.error", new Object[0]);
                    this.showErrorMessage(msg);
                    return false;
                }
                selectedFiles.add(selectedFile);
            }
            if (parent != null) {
                this.setCurrentDirectory(parent);
            }
            this.setSelection(selectedFiles);
            if (selectedFiles.size() > 0 && selectedFiles.size() == paths.length) {
                return true;
            }
        }
        return false;
    }

    private String[] parsePaths(String text) {
        ClientFileChooserCardinality cardinality = this.getCardinality();
        String separator = MULTIPLE_PATHS_SEPARATOR;
        String[] paths = cardinality == ClientFileChooserCardinality.MULTIPLE_CHOOSE && text.contains(separator) ? text.split(separator) : new String[]{text};
        return paths;
    }

    private ClientFile getFileFromPath(String path) {
        String[] fileName = this.parsePath(path);
        ClientFile currentDir = FileUtils.isAbsolutePath((String)path) ? this.getRoot() : this.getCurrentDirectory();
        ClientFile file = this.findFile(currentDir, fileName);
        if (file == null) {
            String msg = this.getString("path.not.found.warning", path);
            StandardDialogs.showWarningDialog((Component)this, (String)this.getTitle(), (String)msg);
        }
        return file;
    }

    private ClientFile getRoot() {
        ClientFileType clientFileType = this.getClientFileType();
        Object root = null;
        switch (clientFileType) {
            case REMOTE: {
                root = ClientFileChooserUtils.getProjectHomeDirectory();
                break;
            }
            case LOCAL: {
                root = ClientFileChooserUtils.getLocalRootDirectory(this.getCurrentDirectory());
                break;
            }
            case SGA: {
                ClientFile currDir = this.getCurrentDirectory();
                root = "/".equals(currDir.getStringPath()) ? currDir : new ClientSGAFile(((ClientSGAFile)currDir).getSGAName(), "/");
            }
        }
        return root;
    }

    private ClientFileType getClientFileType() {
        ClientFile currentDirectory = this.getCurrentDirectory();
        return currentDirectory.getClientFileType();
    }

    private ClientFile findFile(ClientFile baseDir, String[] path) {
        if (path == null) {
            return null;
        }
        if (path.length == 1 && path[0].equals(".")) {
            return baseDir;
        }
        if (this.getClientFileType() == ClientFileType.LOCAL) {
            File file = new File(baseDir.getStringPath(), FileUtils.joinPath((String[])path));
            if (!file.exists()) {
                return null;
            }
            return new ClientLocalFile(file);
        }
        if (this.getClientFileType() == ClientFileType.SGA) {
            ClientSGAFile file = (ClientSGAFile)baseDir;
            String sgaPath = this.buildSGAPath(file, path);
            try {
                SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
                return sgaService.getFile(file.getSGAName(), sgaPath);
            }
            catch (RemoteException e) {
                return null;
            }
        }
        ClientFile currentFile = baseDir;
        try {
            block5: for (int i = 0; i < path.length; ++i) {
                ClientFile[] children;
                if (currentFile == null) {
                    return null;
                }
                if (currentFile.isDirectory()) {
                    children = currentFile.getChildren();
                    if (children == null) {
                        return null;
                    }
                } else {
                    return null;
                }
                currentFile = null;
                for (ClientFile child : children) {
                    if (!child.getName().equals(path[i])) continue;
                    currentFile = child;
                    continue block5;
                }
            }
            return currentFile;
        }
        catch (PermissionException pe) {
            return null;
        }
        catch (Exception e) {
            String title = this.getTitle();
            String message = e.getMessage();
            StandardErrorDialogs.showErrorDialog(this, title, message, e);
            return null;
        }
    }

    private String buildSGAPath(ClientSGAFile baseDir, String[] path) {
        String basePath = baseDir.getStringPath();
        String separator = baseDir.getSeparator();
        String relativePath = FileUtils.joinPath((String)separator, (String[])path);
        StringBuilder sgaPath = new StringBuilder();
        sgaPath.append(basePath);
        if (!relativePath.startsWith(separator) && !basePath.endsWith(separator)) {
            sgaPath.append(separator);
        }
        sgaPath.append(relativePath);
        return sgaPath.toString();
    }

    private String[] parsePath(String path) {
        String filePath;
        if (path != null && !(filePath = path.trim()).isEmpty()) {
            String[] splitPath = FileUtils.splitPath((String)filePath, (char)'/');
            return splitPath;
        }
        return null;
    }

    private boolean handleOkSaveType() {
        String fileName;
        ClientFile file;
        ClientFile currentDir;
        String[] path;
        String text;
        block16: {
            ClientFileChooserSelectionMode selectionMode;
            block15: {
                text = this.selectionText.getText();
                path = this.parsePath(text);
                if (path == null) {
                    return false;
                }
                currentDir = FileUtils.isAbsolutePath((String)text) ? this.getRoot() : this.getCurrentDirectory();
                file = this.findFile(currentDir, path);
                if (file == null) {
                    if (path.length > 1) {
                        ClientFile dir = this.findParent(currentDir, path);
                        if (dir == null) {
                            String tag = "parent.not.found.warning";
                            String msg = this.getString(tag, text);
                            StandardDialogs.showWarningDialog((Component)this, (String)this.getTitle(), (String)msg);
                            return false;
                        }
                        if (!dir.canWrite()) {
                            this.showPermissionError();
                            return false;
                        }
                    }
                    String[] dirPath = currentDir.getPath();
                    this.selectedSavePath = this.appendPath(dirPath, path);
                    String fileName2 = this.selectedSavePath[this.selectedSavePath.length - 1];
                    boolean matchedTypes = this.areTypesMatched(fileName2);
                    return matchedTypes;
                }
                ClientFileFilterInterface filter = this.getSelectedFilter();
                selectionMode = this.getSelectionMode();
                if (!file.isDirectory()) break block15;
                switch (selectionMode) {
                    case FILES_ONLY: {
                        this.setCurrentDirectory(file);
                        return false;
                    }
                    case DIRECTORIES_ONLY: {
                        if (!filter.accept(file, ClientFileFilterInterface.Operation.SELECTION)) {
                            this.setCurrentDirectory(file);
                            return false;
                        }
                        break block16;
                    }
                    default: {
                        String msg = String.format("Modo inv\u00e1lido: %s.", new Object[]{selectionMode});
                        throw new IllegalStateException(msg);
                    }
                }
            }
            if (selectionMode == ClientFileChooserSelectionMode.DIRECTORIES_ONLY) {
                String tag = "not.dir.error";
                String msg = this.getString("not.dir.error", file.getName());
                this.showErrorMessage(msg);
                return false;
            }
        }
        if (!file.canWrite()) {
            this.showPermissionError();
            return false;
        }
        if (text.equals(".")) {
            this.selectedSavePath = path;
            fileName = currentDir.getName();
        } else {
            String[] dirPath = currentDir.getPath();
            this.selectedSavePath = this.appendPath(dirPath, path);
            fileName = this.selectedSavePath[this.selectedSavePath.length - 1];
        }
        if (!this.areTypesMatched(fileName)) {
            return false;
        }
        return this.canCloseAsUserConfirmedOverwrite(this.selectedSavePath);
    }

    private ClientFile findParent(ClientFile baseDir, String[] path) {
        String[] parent = new String[path.length - 1];
        System.arraycopy(path, 0, parent, 0, path.length - 1);
        ClientFile dir = this.findFile(baseDir, parent);
        return dir;
    }

    private void initComponent() {
        this.setAllFilter();
        ClientFileChooserActionListener mlst = new ClientFileChooserActionListener(this);
        this.tablePanel.addTablePanelActionListener(mlst);
        ClientFileChooserSelectionListener slst = new ClientFileChooserSelectionListener(this);
        this.tablePanel.addTablePanelSelectionListener(slst);
        BorderUtil.setLowBorder((JComponent)this.tablePanel);
        JPanel selectionPanel = this.buildSelectionPanel();
        JPanel buttonsPanel = this.buildButtonsPanel();
        JPanel toolPanel = this.buildToolPanel();
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        southPanel.add((Component)selectionPanel, "North");
        southPanel.add((Component)buttonsPanel, "South");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.tablePanel, "Center");
        contentPane.add((Component)toolPanel, "North");
        contentPane.add((Component)southPanel, "South");
        Dimension size = new Dimension(600, 400);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setLocalHomeButtonVisible(true);
        this.setLocalRootButtonVisible(true);
        this.setProjectHomeButtonVisible(true);
        this.initCurrentDirectory();
        this.setChosenItens(null);
        this.setSelectionMode(ClientFileChooserSelectionMode.FILES_ONLY);
        this.setSelectionType(ClientFileChooserType.OPEN);
        this.setCardinality(ClientFileChooserCardinality.SINGLE_CHOOSE);
        this.setSelection(null);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initCurrentDirectory() {
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        if (desktopFrame == null) {
            String tag = "no.desktop.detected.error";
            String msg = this.getString("no.desktop.detected.error", new Object[0]);
            this.showErrorMessage(msg);
            this.die();
            return;
        }
        CommonClientProject project = desktopFrame.getProject();
        if (project == null) {
            this.setLocalHomeDirectory();
        } else {
            this.setProjectHomeDirectory();
        }
    }

    private void internalSetViewFilter(ClientFileFilterInterface filter) {
        if (this.getSelectionType() == ClientFileChooserType.OPEN) {
            this.setChosenItens(null);
        }
        this.tablePanel.setFilter(filter);
    }

    public final boolean isHiddenFilesShown() {
        return this.tablePanel.isHiddenFilesShown();
    }

    public final void refresh() {
        this.setCurrentDirectory(this.getCurrentDirectory());
    }

    private void setAllFilter() {
        ArrayList<ClientFileFilterInterface> all = new ArrayList<ClientFileFilterInterface>();
        all.add(new ClientFileAllFilter());
        this.setViewFilters(all);
    }

    public final void setCardinality(ClientFileChooserCardinality flag) {
        ClientFileChooserType tp = this.getSelectionType();
        if (tp == ClientFileChooserType.SAVE) {
            return;
        }
        this.tablePanel.setCardinality(flag);
    }

    public void setChosenItens(List<ClientFile> list) {
        if (list != null) {
            for (ClientFile file : list) {
                if (file.canRead()) continue;
                this.showPermissionError();
                this.chosenItens = null;
                return;
            }
        }
        this.chosenItens = list;
        this.updateSelectionText(this.chosenItens);
    }

    public final void setCurrentDirectory(ClientFile directory) {
        if (!directory.canExecute() || !directory.canRead()) {
            this.showPermissionError();
            return;
        }
        this.tablePanel.setSelection(null);
        this.tablePanel.setRootDirectory(directory);
        this.hierarchyCombo.setLeafDirectory(directory);
        this.clearSelectionText();
        this.setChosenItens(null);
        this.selectedSavePath = null;
    }

    public void showPermissionError() {
        StandardErrorDialogs.showErrorDialog(this.getOwner(), new PermissionException());
    }

    public void setLocalHomeButtonVisible(boolean visible) {
        this.localHomeDirButton.setVisible(visible);
    }

    public final void setLocalHomeDirectory() {
        ClientLocalFile home = ClientFileChooserUtils.getLocalHomeDirectory();
        if (home != null) {
            this.setCurrentDirectory(home);
        }
    }

    public void setLocalRootButtonVisible(boolean visible) {
        this.localRootDirButton.setVisible(visible);
    }

    public final void setLocalRootDirectory() {
        ClientLocalFile root = ClientFileChooserUtils.getLocalRootDirectory(this.getCurrentDirectory());
        if (root != null) {
            this.setCurrentDirectory(root);
        }
    }

    public void setProjectHomeButtonVisible(boolean visible) {
        this.projHomeDirButton.setVisible(visible);
    }

    public final void setProjectHomeDirectory() {
        CommonClientProject project = this.getProjectOrDie();
        ClientProjectFile home = project.getRoot();
        if (home != null) {
            this.setCurrentDirectory((ClientFile)home);
        }
    }

    public void setSelection(List<ClientFile> newSelection) {
        if (newSelection == null) {
            ArrayList<ClientFile> empty = new ArrayList<ClientFile>();
            this.setSelection(empty);
            return;
        }
        this.tablePanel.setSelection(newSelection);
    }

    public final void setSelectionMode(ClientFileChooserSelectionMode mode) {
        ClientFileChooserType tp = this.getSelectionType();
        if (tp == ClientFileChooserType.SAVE) {
            return;
        }
        this.tablePanel.setSelectionMode(mode);
    }

    public final void setSelectionType(ClientFileChooserType type) {
        switch (type) {
            case OPEN: {
                break;
            }
            case SAVE: {
                this.setCardinality(ClientFileChooserCardinality.SINGLE_CHOOSE);
            }
        }
        this.type = type;
    }

    private void setUpDirectory() {
        ClientFile dir = this.getCurrentDirectory();
        if (dir == null) {
            return;
        }
        ClientFile parent = dir.getParent();
        if (parent == null) {
            return;
        }
        this.setCurrentDirectory(parent);
    }

    public final void setViewFilters(ClientFileFilterInterface filter) {
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        filters.add(filter);
        this.setViewFilters(filters);
    }

    public final void setViewFilters(ClientFileFilterInterface[] filters) {
        List<ClientFileFilterInterface> list = Arrays.asList(filters);
        this.setViewFilters(list);
    }

    public final void setViewFilters(List<ClientFileFilterInterface> filters) {
        this.viewFilters.clear();
        if (filters == null || filters.size() <= 0) {
            this.setAllFilter();
            return;
        }
        this.viewFilters.addAll(filters);
        ComboUtil.updateFromList((JComboBox)this.filterCombo, this.viewFilters, (int)0);
        Object sel = this.filterCombo.getSelectedItem();
        this.internalSetViewFilter((ClientFileFilterInterface)sel);
        this.tablePanel.refresh();
    }

    private void showErrorMessage(String msg) {
        StandardDialogs.showErrorDialog((Component)this, (String)this.getTitle(), (String)msg);
    }

    public final void showHiddenFiles(boolean flag) {
        this.tablePanel.showHiddenFiles(flag);
        this.filterToggle.setSelected(flag);
    }

    void updateSelectionText(List<ClientFile> selections) {
        if (selections == null) {
            this.clearSelectionText();
            return;
        }
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (ClientFile sel : selections) {
            String path = sel.equals(this.getCurrentDirectory()) ? "." : sel.getName();
            builder.append(sep);
            builder.append(path);
            sep = "; ";
        }
        String text = builder.toString().trim();
        this.selectionText.setText(text.trim());
    }

    public ClientFileChooser(Window window) {
        super(window, "", Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponent();
    }
}

