/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser;

import csbase.client.ClientSmartFile;
import csbase.client.ClientSmartFileFactory;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.tasks.ChangeFileTypeTask;
import csbase.client.project.tasks.CreateFileTask;
import csbase.client.project.tasks.GetFileTask;
import csbase.client.util.filechooser.ClientFileChooser;
import csbase.client.util.filechooser.ClientFileChooserCardinality;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.client.util.filechooser.filters.ClientFileAllFilter;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface;
import csbase.client.util.filechooser.filters.ClientFileMultipleTypesFilter;
import csbase.client.util.filechooser.filters.ClientFileSingleTypeFilter;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileType;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ClientProjectFileChooserUtil {
    public static final OperationResult browseSingleFileInOpenMode(Application application, Collection<String> fileTypes, boolean allowAll) {
        ApplicationFrame frame = application.getApplicationFrame();
        return ClientProjectFileChooserUtil.browseSingleFileInOpenMode((Window)frame, fileTypes, application.getName(), allowAll);
    }

    public static final OperationResult browseSingleFileInOpenMode(Window window, String fileType, String title, boolean allowAll) {
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add(fileType);
        return ClientProjectFileChooserUtil.browseSingleFileInOpenMode(window, fileTypes, title, allowAll);
    }

    public static final OperationResult browseSingleFileInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll) {
        return ClientProjectFileChooserUtil.browseSingleInOpenMode(window, title, ClientFileChooserSelectionMode.FILES_ONLY, allowAll, null, fileTypes.toArray(new String[0]));
    }

    public static final OperationResult browseSingleDirectoryInOpenMode(Window window, String fileType, String title, boolean allowAll) {
        return ClientProjectFileChooserUtil.browseSingleInOpenMode(window, title, ClientFileChooserSelectionMode.DIRECTORIES_ONLY, allowAll, fileType, new String[0]);
    }

    public static final OperationResult browseSingleDirectoryInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll) {
        return ClientProjectFileChooserUtil.browseSingleInOpenMode(window, title, ClientFileChooserSelectionMode.DIRECTORIES_ONLY, allowAll, null, fileTypes.toArray(new String[0]));
    }

    public static final OperationResult browseSingleInOpenMode(Window window, String title, ClientFileChooserSelectionMode selectionMode, boolean allowAll, String defaultType, String ... fileTypes) {
        ClientFileChooser chooser = ClientProjectFileChooserUtil.buildChooser(window, title, ClientFileChooserType.OPEN, selectionMode, ClientFileChooserCardinality.SINGLE_CHOOSE, allowAll, defaultType, fileTypes);
        if (chooser == null) {
            return null;
        }
        chooser.setVisible(true);
        List<ClientFile> selected = chooser.getChosenItens();
        if (selected == null || selected.isEmpty()) {
            return null;
        }
        ClientProjectFile first = (ClientProjectFile)selected.get(0);
        OperationResult result = new OperationResult(chooser, first);
        return result;
    }

    private static ClientFileChooser buildChooser(Window window, String title, ClientFileChooserType selectionType, ClientFileChooserSelectionMode selectionMode, ClientFileChooserCardinality cardinality, boolean allowAll, String defaultFileType, String ... fileTypes) {
        ClientFileChooser chooser = new ClientFileChooser(window);
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        if (project == null) {
            StandardDialogs.showErrorDialog((Component)window, null, (String)"No project!");
            return null;
        }
        ClientProjectFile root = project.getRoot();
        chooser.setCurrentDirectory((ClientFile)root);
        chooser.setTitle(title);
        chooser.setSelectionMode(selectionMode);
        chooser.setSelectionType(selectionType);
        chooser.setLocalHomeButtonVisible(false);
        chooser.setLocalRootButtonVisible(false);
        chooser.setProjectHomeButtonVisible(true);
        chooser.setCardinality(cardinality);
        ArrayList<ClientFileFilterInterface> filters = new ArrayList<ClientFileFilterInterface>();
        ClientFileSingleTypeFilter defaultFilter = null;
        ArrayList<String> allFileTypes = new ArrayList<String>();
        if (defaultFileType != null) {
            allFileTypes.add(defaultFileType);
        }
        for (String fileType : fileTypes) {
            if (allFileTypes.contains(fileType)) continue;
            allFileTypes.add(fileType);
        }
        if (defaultFileType == null && allFileTypes.size() > 1) {
            filters.add(new ClientFileMultipleTypesFilter(allFileTypes));
        }
        for (String fileType : allFileTypes) {
            ClientFileSingleTypeFilter filter = new ClientFileSingleTypeFilter(fileType);
            filters.add(filter);
            if (defaultFileType == null || !defaultFileType.equals(fileType)) continue;
            defaultFilter = filter;
        }
        if (defaultFileType != null && allFileTypes.size() > 1) {
            filters.add(new ClientFileMultipleTypesFilter(allFileTypes));
        }
        if (allowAll) {
            filters.add(new ClientFileAllFilter());
        }
        chooser.setViewFilters(filters);
        if (defaultFilter != null) {
            chooser.setSelectedFilter(defaultFilter);
        }
        return chooser;
    }

    public static final OperationResult browseSingleFileInSaveMode(Application application, String fileType, boolean allowAll, boolean createChosen) {
        ApplicationFrame frame = application.getApplicationFrame();
        return ClientProjectFileChooserUtil.browseSingleFileInSaveMode(frame, fileType, application.getName(), allowAll, createChosen);
    }

    public static final OperationResult browseSingleFileInSaveMode(Application application, Collection<String> fileTypes, String defaultFileType, boolean allowAll, boolean createChosen) {
        ApplicationFrame frame = application.getApplicationFrame();
        return ClientProjectFileChooserUtil.browseSingleFileInSaveMode(frame, fileTypes, defaultFileType, application.getName(), allowAll, createChosen);
    }

    public static final OperationResult browseSingleFileInSaveMode(Window window, String fileType, String title, boolean allowAll, boolean createChosen) {
        ArrayList<String> fileTypes = new ArrayList<String>();
        if (fileType != null) {
            fileTypes.add(fileType);
        }
        return ClientProjectFileChooserUtil.browseSingleFileInSaveMode(window, fileTypes, fileType, title, allowAll, createChosen);
    }

    public static final OperationResult browseSingleFileInSaveMode(Window window, Collection<String> fileTypes, String defaultFileType, String title, boolean allowAll, boolean createChosen) {
        return ClientProjectFileChooserUtil.browseSingleInSaveMode(window, title, ClientFileChooserSelectionMode.FILES_ONLY, createChosen, allowAll, defaultFileType, fileTypes.toArray(new String[0]));
    }

    public static final OperationResult browseSingleDirectoryInSaveMode(Window window, String fileType, String title, boolean allowAll, boolean createChosen) {
        ArrayList<String> fileTypes = new ArrayList<String>();
        if (fileType != null) {
            fileTypes.add(fileType);
        }
        return ClientProjectFileChooserUtil.browseSingleDirectoryInSaveMode(window, fileTypes, fileType, title, allowAll, createChosen);
    }

    public static final OperationResult browseSingleDirectoryInSaveMode(Window window, Collection<String> fileTypes, String defaultFileType, String title, boolean allowAll, boolean createChosen) {
        return ClientProjectFileChooserUtil.browseSingleInSaveMode(window, title, ClientFileChooserSelectionMode.DIRECTORIES_ONLY, createChosen, allowAll, defaultFileType, fileTypes.toArray(new String[0]));
    }

    public static final OperationResult browseSingleInSaveMode(Window window, String title, ClientFileChooserSelectionMode selectionMode, boolean createChosen, boolean allowAll, String defaultFileType, String ... fileTypes) {
        ClientFileChooser chooser = ClientProjectFileChooserUtil.buildChooser(window, title, ClientFileChooserType.SAVE, selectionMode, ClientFileChooserCardinality.SINGLE_CHOOSE, allowAll, defaultFileType, fileTypes);
        if (chooser == null) {
            return null;
        }
        chooser.setVisible(true);
        String[] selectedSavePath = chooser.getSelectedSavePath();
        if (selectedSavePath == null || selectedSavePath.length <= 0) {
            return null;
        }
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        OperationResult result = new OperationResult(chooser, project, selectedSavePath, createChosen);
        return result;
    }

    public static final List<OperationResult> browseMultipleFilesInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll) {
        return ClientProjectFileChooserUtil.browseMultipleInOpenMode(window, title, ClientFileChooserSelectionMode.FILES_ONLY, allowAll, null, fileTypes.toArray(new String[0]));
    }

    public static final List<OperationResult> browseMultipleDirectoriesInOpenMode(Window window, String fileType, String title, boolean allowAll) {
        return ClientProjectFileChooserUtil.browseMultipleInOpenMode(window, title, ClientFileChooserSelectionMode.DIRECTORIES_ONLY, allowAll, fileType, new String[0]);
    }

    public static final List<OperationResult> browseMultipleDirectoriesInOpenMode(Window window, Collection<String> fileTypes, String title, boolean allowAll) {
        return ClientProjectFileChooserUtil.browseMultipleInOpenMode(window, title, ClientFileChooserSelectionMode.DIRECTORIES_ONLY, allowAll, null, fileTypes.toArray(new String[0]));
    }

    public static final List<OperationResult> browseMultipleInOpenMode(Window window, String title, ClientFileChooserSelectionMode selectionMode, boolean allowAll, String defaultFileType, String ... fileTypes) {
        ClientFileChooser chooser = ClientProjectFileChooserUtil.buildChooser(window, title, ClientFileChooserType.OPEN, selectionMode, ClientFileChooserCardinality.MULTIPLE_CHOOSE, allowAll, defaultFileType, fileTypes);
        if (chooser == null) {
            return null;
        }
        chooser.setVisible(true);
        List<ClientFile> selected = chooser.getChosenItens();
        if (selected == null || selected.isEmpty()) {
            return null;
        }
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        for (ClientFile sel : selected) {
            OperationResult result = new OperationResult(chooser, (ClientProjectFile)sel);
            results.add(result);
        }
        return results;
    }

    public static class OperationResult {
        private final boolean existsFile;
        private final ClientProjectFile file;
        private final String[] path;
        private final ClientFileChooser chooser;

        public final boolean existsFile() {
            return this.existsFile;
        }

        public final ClientProjectFile getClientProjectFile() {
            return this.file;
        }

        public ClientSmartFile getClientSmartFile() {
            if (this.file == null) {
                return null;
            }
            return ClientSmartFileFactory.getInstance().create(this.file);
        }

        public final String getStringPath() {
            String[] pth = this.getPath();
            if (pth == null || pth.length <= 0) {
                return null;
            }
            String joinPath = FileUtils.joinPath((char)'/', (String[])pth);
            return joinPath;
        }

        public final String[] getPath() {
            return this.path;
        }

        public OperationResult(ClientFileChooser chooser, CommonClientProject project, String[] path, boolean createChosen) {
            this.chooser = chooser;
            this.path = path;
            ClientProjectFile tmpFile = GetFileTask.runTask(chooser.getOwner(), project, path);
            if (createChosen) {
                if (tmpFile == null) {
                    this.file = this.createFromPath();
                    this.existsFile = this.file != null;
                } else {
                    this.file = tmpFile;
                    this.existsFile = true;
                    String fileName = path[path.length - 1];
                    ProjectFileType fileType = this.getChosenFileType(fileName);
                    ChangeFileTypeTask.runTask(chooser.getOwner(), this.file, fileType);
                }
            } else {
                this.file = tmpFile;
                this.existsFile = this.file != null;
            }
        }

        public OperationResult(ClientFileChooser chooser, ClientProjectFile file) {
            this.chooser = chooser;
            if (file == null) {
                this.path = null;
                this.existsFile = false;
            } else {
                this.path = file.getPath();
                this.existsFile = true;
            }
            this.file = file;
        }

        public final ClientProjectFile createFromPath() {
            ClientProjectFile parent;
            if (this.file != null) {
                return this.file;
            }
            DesktopFrame desktopFrame = DesktopFrame.getInstance();
            CommonClientProject project = desktopFrame.getProject();
            if (project == null) {
                return null;
            }
            if (this.path == null) {
                return null;
            }
            int pathLength = this.path.length;
            if (pathLength == 1) {
                parent = project.getRoot();
            } else {
                String[] parentPath = new String[pathLength - 1];
                for (int i = 0; i < parentPath.length; ++i) {
                    parentPath[i] = this.path[i];
                }
                parent = GetFileTask.runTask(this.chooser.getOwner(), project, parentPath);
            }
            String fileName = this.path[pathLength - 1];
            ProjectFileType tp = this.getChosenFileType(fileName);
            if (tp == null) {
                String msg = this.getString("unsupported.file.type", new Object[0]);
                String extension = FileUtils.getFileExtension((String)fileName);
                String err = msg + " - (." + extension + ")";
                StandardDialogs.showErrorDialog((Component)this.chooser.getOwner(), (String)"", (String)err);
                return null;
            }
            String fileType = tp.getCode();
            ClientProjectFile newFile = CreateFileTask.runTask(this.chooser.getOwner(), project, parent, fileName, fileType);
            if (newFile == null) {
                return null;
            }
            return newFile;
        }

        private String getString(String tag, Object ... args) {
            String prefix1 = ClientFileChooser.class.getSimpleName();
            String prefix2 = this.getClass().getSimpleName();
            String prefix = prefix1 + "." + prefix2;
            String realTag = prefix + "." + tag;
            String fmt = LNG.get((String)realTag);
            String msg = String.format(fmt, args);
            return msg;
        }

        private final ProjectFileType getChosenFileType(String fileName) {
            ProjectFileType filterType = this.chooser.getFileTypeFromSelectedFilter();
            if (filterType == null) {
                ProjectFileType extensionType = this.chooser.getFileTypeFromFileName(fileName);
                return extensionType;
            }
            return filterType;
        }
    }
}

